/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.hyperlinks;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.ExternalBeanHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.HyperlinkUtils;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.NodeElementHyperlink;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.config.ui.hyperlinks.ExtendedExternalBeanHyperlink;
import org.springframework.ide.eclipse.config.ui.hyperlinks.ExtendedNodeElementHyperlink;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class XmlBackedHyperlinkProvider {
    private final ITextViewer textViewer;
    private final IDOMElement input;
    private final String name;

    public XmlBackedHyperlinkProvider(ITextViewer textViewer, IDOMElement input, String attrName) {
        this.textViewer = textViewer;
        this.input = input;
        this.name = attrName;
    }

    protected IHyperlink createHyperlink(String value, IRegion region) {
        Node bean;
        IHyperlinkCalculator calc = this.createHyperlinkCalculator();
        IHyperlink hyperlink = calc.createHyperlink(this.name, value, (Node)this.input, this.input.getParentNode(), (IDocument)this.input.getStructuredDocument(), this.textViewer, region, region);
        IFile file = BeansEditorUtils.getFile((IDocument)this.input.getStructuredDocument());
        if (hyperlink instanceof NodeElementHyperlink && (bean = BeansEditorUtils.getFirstReferenceableNodeById((Document)this.input.getOwnerDocument(), (String)value, (IFile)file)) != null) {
            IRegion targetRegion = HyperlinkUtils.getHyperlinkRegion((Node)bean);
            return new ExtendedNodeElementHyperlink(bean, region, targetRegion, this.textViewer);
        }
        if (hyperlink instanceof ExternalBeanHyperlink) {
            for (IBean modelBean : BeansEditorUtils.getBeansFromConfigSets((IFile)file)) {
                if (!modelBean.getElementName().equals(value)) continue;
                return new ExtendedExternalBeanHyperlink(modelBean, region);
            }
        }
        return hyperlink;
    }

    protected abstract IHyperlinkCalculator createHyperlinkCalculator();

    protected IDOMAttr getAttribute() {
        Attr attrNode = this.input.getAttributeNode(this.name);
        if (attrNode != null) {
            return (IDOMAttr)attrNode;
        }
        return null;
    }

    private ITextRegion getCompletionRegion() {
        IDOMAttr attr = this.getAttribute();
        if (attr != null) {
            return attr.getValueRegion();
        }
        return null;
    }

    public boolean open(String value) {
        IHyperlink hyperlink;
        Region region = null;
        if (this.getAttribute() != null && this.getCompletionRegion() != null) {
            int start = this.input.getStartStructuredDocumentRegion().getStart() + this.getCompletionRegion().getStart();
            region = new Region(start, this.getCompletionRegion().getLength());
        }
        if ((hyperlink = this.createHyperlink(value, (IRegion)region)) != null) {
            hyperlink.open();
            return true;
        }
        return false;
    }
}

