/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.integration.graph.model;

import java.util.List;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.core.schemas.IntegrationSchemaConstants;
import org.springframework.ide.eclipse.config.graph.model.AbstractConfigGraphDiagram;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.ParallelActivity;
import org.springframework.ide.eclipse.config.ui.editors.integration.graph.model.ImplicitTransition;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChainContainerElement
extends ParallelActivity {
    public ChainContainerElement() {
    }

    public ChainContainerElement(IDOMElement input, AbstractConfigGraphDiagram diagram) {
        super(input, diagram);
    }

    public String getInputName() {
        return IntegrationSchemaConstants.ELEM_CHAIN;
    }

    protected void updateTransitionsFromXml() {
        IDOMElement input;
        super.updateTransitionsFromXml();
        if (this.getChildren().size() > 1 && (input = this.getInput()) != null && input.hasChildNodes()) {
            IDOMElement prev = null;
            IDOMElement next = null;
            NodeList children = input.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child instanceof IDOMElement) {
                    prev = next;
                    next = (IDOMElement)child;
                }
                if (prev != null && next != null) {
                    Activity prevActivity = null;
                    Activity nextActivity = null;
                    List parts = this.getChildren();
                    for (Activity activity : parts) {
                        if (prev.equals(activity.getInput())) {
                            prevActivity = activity;
                        }
                        if (!next.equals(activity.getInput())) continue;
                        nextActivity = activity;
                    }
                    if (nextActivity != null && prevActivity != null) {
                        new ImplicitTransition(prevActivity, nextActivity, null);
                    }
                }
                ++i;
            }
        }
    }
}

