/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.integration.graph;

import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.springframework.ide.eclipse.config.core.ConfigCoreUtils;
import org.springframework.ide.eclipse.config.core.formatting.ShallowFormatProcessorXML;
import org.springframework.ide.eclipse.config.core.schemas.IntegrationSchemaConstants;
import org.springframework.ide.eclipse.config.graph.model.commands.AbstractConnectionCreateCommand;
import org.w3c.dom.Node;

public class RecipientConnectionCreateCommand
extends AbstractConnectionCreateCommand {
    private final ShallowFormatProcessorXML formatter = new ShallowFormatProcessorXML();
    protected String oldTargetId;
    protected String targetId;

    public RecipientConnectionCreateCommand(ITextEditor textEditor) {
        super(textEditor, 2);
    }

    public boolean canExecute() {
        if (super.canExecute()) {
            this.oldTargetId = this.sourceElement.getAttribute(IntegrationSchemaConstants.ATTR_CHANNEL);
            this.targetId = this.targetElement.getAttribute(IntegrationSchemaConstants.ATTR_ID);
            if (this.targetId != null && this.targetId.trim().length() != 0) {
                return true;
            }
        }
        return false;
    }

    public void execute() {
        IDOMDocument document = (IDOMDocument)this.sourceElement.getOwnerDocument();
        IDOMModel model = document.getModel();
        if (model != null) {
            model.beginRecording((Object)this);
            IDOMElement recipient = (IDOMElement)document.createElement(IntegrationSchemaConstants.ELEM_RECIPIENT);
            recipient.setPrefix(ConfigCoreUtils.getPrefixForNamespaceUri((IDOMDocument)document, (String)IntegrationSchemaConstants.URI));
            this.sourceElement.appendChild((Node)recipient);
            this.processor.insertDefaultAttributes(recipient);
            this.formatter.formatNode((Node)recipient);
            this.formatter.formatNode((Node)this.sourceElement);
            recipient.setAttribute(IntegrationSchemaConstants.ATTR_CHANNEL, this.targetId);
            model.endRecording((Object)this);
        }
    }
}

