/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.jdt.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.ide.eclipse.data.jdt.core.QueryMethodPart;
import org.springframework.util.Assert;

class QueryMethodCandidate {
    private final Pattern pattern = Pattern.compile("^(find|read|get)(\\p{Upper}.*?)??By");
    private final Pattern CONCATENATOR_PATERN = Pattern.compile(".*(And|Or)(?=\\p{Upper}.*?)?");
    private final String name;
    private final int prefixLength;
    private final Class<?> entityClass;

    public QueryMethodCandidate(String name, Class<?> entityType) {
        Assert.hasText((String)name, (String)"Method name must not be null or empty!");
        Assert.notNull(entityType, (String)"Entity type must not be null!");
        Matcher matcher = this.pattern.matcher(name);
        boolean prefixFound = matcher.find();
        this.prefixLength = prefixFound ? matcher.end() : 0;
        this.name = prefixFound ? name.substring(matcher.end()) : name;
        this.entityClass = entityType;
    }

    public QueryMethodPart getPartAtPosition(int i) {
        int endIndex;
        if (i < this.prefixLength || i > this.prefixLength + this.name.length()) {
            return null;
        }
        Matcher matcher = this.CONCATENATOR_PATERN.matcher(this.name);
        int startIndex = matcher.find() ? matcher.end() : 0;
        int n = endIndex = i - this.prefixLength > this.name.length() ? this.name.length() : i - this.prefixLength;
        if (startIndex < 0 || endIndex < 0 || startIndex > endIndex) {
            return null;
        }
        String subName = startIndex >= this.name.length() ? "" : this.name.substring(startIndex, endIndex);
        return new QueryMethodPart(subName, this.entityClass);
    }
}

