/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.util.ArrayList;
import java.util.List;

public class SpringVersion {
    private final String fullVersion;
    private final String display;
    public static final SpringVersion DEFAULT = new SpringVersion("Default");

    public SpringVersion(String display) {
        this.display = display;
        this.fullVersion = String.valueOf(display) + ".RELEASE";
    }

    public String getDisplay() {
        return this.display;
    }

    public String getVersion() {
        return this.fullVersion;
    }

    public static List<SpringVersion> getVersions() {
        ArrayList<SpringVersion> versions = new ArrayList<SpringVersion>();
        versions.add(DEFAULT);
        versions.add(new SpringVersion("3.2.3"));
        versions.add(new SpringVersion("3.1.4"));
        versions.add(new SpringVersion("3.0.7"));
        return versions;
    }

    public static SpringVersion resolveSpringVersion(String springVersion) {
        if (springVersion == null) {
            return null;
        }
        List<SpringVersion> existingVersions = SpringVersion.getVersions();
        springVersion = springVersion.trim();
        for (SpringVersion version : existingVersions) {
            if (!version.getVersion().equals(springVersion)) continue;
            return version;
        }
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.display == null ? 0 : this.display.hashCode());
        result = 31 * result + (this.fullVersion == null ? 0 : this.fullVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpringVersion other = (SpringVersion)obj;
        if (this.display == null ? other.display != null : !this.display.equals(other.display)) {
            return false;
        }
        return !(this.fullVersion == null ? other.fullVersion != null : !this.fullVersion.equals(other.fullVersion));
    }
}

