/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.wizard.template.ITemplateWizardPage;
import org.springframework.ide.eclipse.wizard.template.Messages;
import org.springframework.ide.eclipse.wizard.template.TemplateInputCollector;
import org.springframework.ide.eclipse.wizard.template.WizardTextKeyValidator;
import org.springframework.ide.eclipse.wizard.template.infrastructure.Template;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ui.WizardUIInfoElement;

public class NewTemplateWizardPage
extends WizardPage
implements ITemplateWizardPage {
    private IWizardPage nextPage;
    private final TemplateInputCollector inputHandler;
    private final String[] errorMessages;
    private final String[] messages;
    private final Set<WizardTextKeyValidator> validators;
    private static final String CONTROL_DATA_KEY = "org.springframework.ide.eclipse.wizard.template.controldatakey";
    private static final String DEFAULT_DESCRIPTION = Messages.getString("TemplateWizardPage.DEFAULT_DESCRIPTION");

    protected NewTemplateWizardPage(String pageTitle, Template template, TemplateInputCollector inputHandler) {
        super("Template Wizard Page");
        this.inputHandler = inputHandler;
        List<WizardUIInfoElement> elements = inputHandler.getInfoElements();
        this.errorMessages = new String[elements.size()];
        this.messages = new String[elements.size()];
        this.validators = new HashSet<WizardTextKeyValidator>();
        String title = String.valueOf(pageTitle != null ? String.valueOf(pageTitle) + " - " : "") + template.getName();
        this.setTitle(title);
        this.setDescription(DEFAULT_DESCRIPTION);
        if (template.getIcon() != null) {
            this.setImageDescriptor(template.getIcon());
        }
    }

    public boolean canFlipToNextPage() {
        if (this.hasErrors()) {
            return false;
        }
        return this.nextPage != null;
    }

    public TemplateInputCollector getInputHandler() {
        return this.inputHandler;
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout controlLayout = new GridLayout();
        controlLayout.verticalSpacing = 10;
        control.setLayout((Layout)controlLayout);
        Composite container = new Composite(control, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        List<WizardUIInfoElement> elements = this.inputHandler.getInfoElements();
        int i = 0;
        while (i < elements.size()) {
            WizardUIInfoElement element = elements.get(i);
            String description = null;
            description = element.getRequired() ? String.valueOf(element.getDescription()) + "*" : element.getDescription();
            boolean booleanPrompt = element.getType() == Boolean.class;
            String defaultValue = element.getDefaultValue();
            if (booleanPrompt) {
                Composite buttonContainer = new Composite(container, 0);
                buttonContainer.setLayoutData((Object)new GridData(4, 4, false, false));
                GridLayout layout = new GridLayout(2, false);
                layout.horizontalSpacing = 10;
                buttonContainer.setLayout((Layout)layout);
                Label label = new Label(buttonContainer, 0);
                if (description != null) {
                    label.setText(description);
                }
                label.setLayoutData((Object)new GridData(4, 4, true, false));
                final Button button = new Button(buttonContainer, 32);
                button.setLayoutData((Object)new GridData(4, 4, false, false));
                if (i == 0) {
                    button.setFocus();
                }
                button.setData(CONTROL_DATA_KEY, (Object)element);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        WizardUIInfoElement element = (WizardUIInfoElement)button.getData(NewTemplateWizardPage.CONTROL_DATA_KEY);
                        if (element != null) {
                            NewTemplateWizardPage.this.inputHandler.updateInput(element.getName(), button.getSelection());
                        }
                    }
                });
                if (defaultValue != null && defaultValue.equals("true")) {
                    button.setSelection(true);
                } else if (defaultValue != null && defaultValue.equals("false")) {
                    button.setSelection(false);
                }
            } else {
                Label descriptionLabel = new Label(container, 0);
                if (description != null) {
                    descriptionLabel.setText(description);
                }
                descriptionLabel.setLayoutData((Object)new GridData(4, 4, true, false));
                final Text text = new Text(container, 2048);
                text.setLayoutData((Object)new GridData(4, 4, true, false));
                text.setEditable(true);
                text.setData(CONTROL_DATA_KEY, (Object)element);
                if (defaultValue != null && defaultValue.length() > 0) {
                    text.setText(defaultValue);
                    this.inputHandler.updateInput(element.getName(), defaultValue);
                }
                WizardTextKeyValidator validator = new WizardTextKeyValidator(i, element, text, this){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        WizardUIInfoElement element = (WizardUIInfoElement)text.getData(NewTemplateWizardPage.CONTROL_DATA_KEY);
                        if (element != null) {
                            NewTemplateWizardPage.this.inputHandler.updateInput(element.getName(), text.getText());
                        }
                        super.keyReleased(e);
                    }
                };
                validator.validate();
                this.validators.add(validator);
                text.addKeyListener((KeyListener)validator);
                if (i == 0) {
                    text.setFocus();
                }
            }
            ++i;
        }
        this.setControl((Control)control);
        this.updateMessage();
        this.setPageComplete(this.validatePage());
    }

    @Override
    public String[] getErrorMessages() {
        return this.errorMessages;
    }

    @Override
    public String[] getMessages() {
        return this.messages;
    }

    public IWizardPage getNextPage() {
        if (this.nextPage != null) {
            return this.nextPage;
        }
        return super.getNextPage();
    }

    private boolean hasErrors() {
        String[] stringArray = this.errorMessages;
        int n = this.errorMessages.length;
        int n2 = 0;
        while (n2 < n) {
            String errorMessage = stringArray[n2];
            if (errorMessage != null) {
                return true;
            }
            ++n2;
        }
        stringArray = this.messages;
        n = this.messages.length;
        n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            if (message != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isPageComplete() {
        if (this.hasErrors()) {
            return false;
        }
        if (this.nextPage == null) {
            return true;
        }
        return this.nextPage.getControl() != null && this.nextPage.isPageComplete();
    }

    private void setMessage(String errorMessage, String message) {
        this.setErrorMessage(errorMessage);
        this.setMessage(message);
        this.getWizard().getContainer().updateButtons();
    }

    @Override
    public void setNextPage(IWizardPage page) {
        this.nextPage = page;
    }

    @Override
    public void updateMessage() {
        String[] stringArray = this.errorMessages;
        int n = this.errorMessages.length;
        int n2 = 0;
        while (n2 < n) {
            String errorMsg = stringArray[n2];
            if (errorMsg != null) {
                this.setMessage(errorMsg, null);
                return;
            }
            ++n2;
        }
        stringArray = this.messages;
        n = this.messages.length;
        n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            if (message != null) {
                this.setMessage(null, message);
                return;
            }
            ++n2;
        }
        this.setMessage(null, DEFAULT_DESCRIPTION);
    }

    protected boolean validatePage() {
        for (WizardTextKeyValidator validator : this.validators) {
            validator.validate();
        }
        this.updateMessage();
        return !this.hasErrors();
    }
}

