/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.guides;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.misc.StringMatcher;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.Describable;
import org.springframework.ide.eclipse.wizard.gettingstarted.guides.ChooseOneSection;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.SelectionModel;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;

public class ChooseOneSectionTable<T>
extends ChooseOneSection {
    private SelectionModel<T> selection;
    private String label;
    private T[] options;
    private Text searchBox;
    private ChoicesFilter filter;

    public ChooseOneSectionTable(IPageWithSections owner, String label, SelectionModel<T> selection, T[] options) {
        super(owner);
        this.label = label;
        this.selection = selection;
        this.options = options;
    }

    public LiveExpression<ValidationResult> getValidator() {
        return this.selection.validator;
    }

    public void createContents(Composite page) {
        Composite field = new Composite(page, 0);
        int cols = this.label == null ? 1 : 2;
        GridLayout layout = GridLayoutFactory.fillDefaults().numColumns(cols).create();
        field.setLayout((Layout)layout);
        this.searchBox = new Text(field, 2436);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.searchBox);
        Label fieldNameLabel = null;
        if (this.label != null) {
            fieldNameLabel = new Label(field, 0);
            fieldNameLabel.setText(this.label);
        }
        final TableViewer tv = new TableViewer(field, 2564);
        this.filter = new ChoicesFilter();
        tv.addFilter((ViewerFilter)this.filter);
        tv.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        tv.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tv.setInput(this.options);
        if (fieldNameLabel != null) {
            GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)fieldNameLabel);
        }
        GridDataFactory grab = GridDataFactory.fillDefaults().grab(true, true).hint(-1, 150);
        grab.applyTo((Control)field);
        grab.applyTo((Control)tv.getTable());
        this.whenVisible(tv.getControl(), new Runnable(){

            @Override
            public void run() {
                Object preSelect = ((ChooseOneSectionTable)ChooseOneSectionTable.this).selection.selection.getValue();
                if (preSelect != null) {
                    tv.setSelection((ISelection)new StructuredSelection(preSelect), true);
                } else {
                    tv.setSelection((ISelection)StructuredSelection.EMPTY, true);
                }
            }
        });
        tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = tv.getSelection();
                if (sel.isEmpty()) {
                    ((ChooseOneSectionTable)ChooseOneSectionTable.this).selection.selection.setValue(null);
                } else if (sel instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)sel;
                    ((ChooseOneSectionTable)ChooseOneSectionTable.this).selection.selection.setValue(ss.getFirstElement());
                }
            }
        });
        this.searchBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChooseOneSectionTable.this.filter.setSearchTerm(ChooseOneSectionTable.this.searchBox.getText());
                tv.refresh();
            }
        });
    }

    private void whenVisible(final Control control, final Runnable runnable) {
        PaintListener l = new PaintListener(){

            public void paintControl(PaintEvent e) {
                runnable.run();
                control.removePaintListener((PaintListener)this);
            }
        };
        control.addPaintListener(l);
    }

    private class ChoicesFilter
    extends ViewerFilter {
        private StringMatcher matcher = null;

        public ChoicesFilter() {
            if (ChooseOneSectionTable.this.searchBox != null) {
                this.setSearchTerm(ChooseOneSectionTable.this.searchBox.getText());
            }
        }

        public void setSearchTerm(String text) {
            this.matcher = new StringMatcher(text, true, false);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.matcher == null) {
                return true;
            }
            String label = ChooseOneSectionTable.this.labelProvider.getText(element);
            if (this.match(label)) {
                return true;
            }
            if (element instanceof Describable) {
                String description = ((Describable)element).getDescription();
                return this.match(description);
            }
            return false;
        }

        private boolean match(String text) {
            if (this.matcher == null) {
                return true;
            }
            StringMatcher.Position x = this.matcher.find(text, 0, text.length());
            return x != null;
        }
    }
}

