/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.boot;

import java.net.URLEncoder;
import org.springframework.ide.eclipse.wizard.WizardPlugin;

public class SimpleUriBuilder {
    private final StringBuilder builder;
    private int numparams = 0;

    public SimpleUriBuilder(String baseUrl) {
        this.builder = new StringBuilder(baseUrl);
    }

    public void addParameter(String name, String paramValue) {
        try {
            if (this.numparams == 0) {
                this.builder.append("?");
            } else {
                this.builder.append("&");
            }
            ++this.numparams;
            this.builder.append(URLEncoder.encode(name, "UTF-8"));
            if (paramValue != null) {
                this.builder.append("=");
                this.builder.append(URLEncoder.encode(paramValue, "UTF-8"));
            }
        }
        catch (Exception e) {
            WizardPlugin.log(e);
        }
    }

    public String toString() {
        return this.builder.toString();
    }
}

