/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.wizard.WizardPlugin;

public class WizardImages {
    private static final String WIZBAN = "wizban";
    private static final String OBJ = "obj16";
    private static ImageRegistry imageRegistry;
    public static final ImageDescriptor TEMPLATE_WIZARD_ICON;
    public static final ImageDescriptor TEMPLATE_ICON;
    public static final ImageDescriptor REFRESH_ICON;
    public static final ImageDescriptor TEMPLATE_CATEGORY_ICON;
    private static URL baseURL;

    static {
        TEMPLATE_WIZARD_ICON = WizardImages.create(WIZBAN, "template_wizard.png");
        TEMPLATE_ICON = WizardImages.create(OBJ, "template_project.png");
        REFRESH_ICON = WizardImages.create(OBJ, "refresh.gif");
        TEMPLATE_CATEGORY_ICON = WizardImages.create(OBJ, "category.png");
        baseURL = null;
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)WizardImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry imageRegistry = WizardImages.getImageRegistry();
        Image image = imageRegistry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage(true);
            imageRegistry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static void initBaseURL() {
        if (baseURL == null) {
            baseURL = WizardPlugin.getDefault().getBundle().getEntry("/icons/full/");
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        WizardImages.initBaseURL();
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append("/");
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }
}

