/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.views;

import com.atlassian.connector.eclipse.internal.bamboo.ui.model.TestElement;
import com.atlassian.connector.eclipse.internal.bamboo.ui.views.FailureTrace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionListenerAction;

public class JUnitCopyAction
extends SelectionListenerAction {
    private final FailureTrace fView;
    private final Clipboard fClipboard;
    private TestElement fTestElement;

    public JUnitCopyAction(FailureTrace view, Clipboard clipboard) {
        super("Copy Trace");
        Assert.isNotNull((Object)clipboard);
        this.fView = view;
        this.fClipboard = clipboard;
    }

    public void run() {
        block7: {
            String trace = this.fView.getTrace();
            String source = null;
            if (trace != null) {
                source = this.convertLineTerminators(trace);
            } else if (this.fTestElement != null) {
                source = this.fTestElement.getTestName();
            }
            if (source == null || source.length() == 0) {
                return;
            }
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{this.convertLineTerminators(source)}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.fView.getComposite().getShell(), (String)"Problem Copying to Clipboard", (String)"There was a problem when accessing the system clipboard. Retry?")) break block7;
                this.run();
            }
        }
    }

    public void handleTestSelected(TestElement test) {
        this.fTestElement = test;
    }

    private String convertLineTerminators(String in) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(in);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                printWriter.println(line);
            }
        }
        catch (IOException iOException) {
            return in;
        }
        return stringWriter.toString();
    }
}

