/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.operations;

import com.atlassian.connector.eclipse.internal.bamboo.core.BambooCorePlugin;
import com.atlassian.connector.eclipse.internal.bamboo.core.client.BambooClient;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.BuildDetails;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class RetrieveFullBuildInfoJob
extends Job {
    private IStatus status;
    private String buildLog;
    private BuildDetails buildDetails;
    private final BambooBuild build;
    private final TaskRepository repository;

    public RetrieveFullBuildInfoJob(BambooBuild build, TaskRepository repository) {
        super("Retrieve full build details");
        this.build = build;
        this.repository = repository;
    }

    protected IStatus run(IProgressMonitor monitor) {
        BambooClient client = BambooCorePlugin.getRepositoryConnector().getClientManager().getClient(this.repository);
        IStatus buildLogStatus = Status.OK_STATUS;
        try {
            this.buildLog = client.getBuildLogs(monitor, this.repository, this.build);
        }
        catch (CoreException e) {
            buildLogStatus = new Status(4, "com.atlassian.connector.eclipse.bamboo.ui", "Failed to retrieve build logs for build " + this.build.getPlanKey(), (Throwable)e);
        }
        IStatus buildDetailsStatus = Status.OK_STATUS;
        try {
            this.buildDetails = client.getBuildDetails(monitor, this.repository, this.build);
        }
        catch (CoreException e) {
            buildDetailsStatus = new Status(4, "com.atlassian.connector.eclipse.bamboo.ui", "Failed to retrieve build details for build " + this.build.getPlanKey(), (Throwable)e);
        }
        this.status = new MultiStatus("com.atlassian.connector.eclipse.bamboo.ui", 0, new IStatus[]{buildLogStatus, buildDetailsStatus}, "Retrieval of full build information failed", null);
        return Status.OK_STATUS;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public String getBuildLog() {
        return this.buildLog;
    }

    public BuildDetails getBuildDetails() {
        return this.buildDetails;
    }
}

