/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.actions;

import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooImages;
import com.atlassian.connector.eclipse.internal.bamboo.ui.EclipseBambooBuild;
import com.atlassian.connector.eclipse.internal.bamboo.ui.actions.EclipseBambooBuildSelectionListenerAction;
import com.atlassian.connector.eclipse.internal.bamboo.ui.operations.RetrieveTestResultsJob;
import com.atlassian.connector.eclipse.internal.bamboo.ui.views.TestResultsView;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.BuildDetails;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ShowTestResultsAction
extends EclipseBambooBuildSelectionListenerAction {
    public ShowTestResultsAction() {
        super(null);
        this.initialize();
    }

    private void initialize() {
        this.setText("Show Test Results");
        this.setImageDescriptor(BambooImages.JUNIT);
    }

    void onRun(EclipseBambooBuild eclipseBambooBuild) {
        this.downloadAndShowTestResults(eclipseBambooBuild);
    }

    private void downloadAndShowTestResults(EclipseBambooBuild eclipseBambooBuild) {
        final BambooBuild build = eclipseBambooBuild.getBuild();
        RetrieveTestResultsJob job = new RetrieveTestResultsJob(build, eclipseBambooBuild.getTaskRepository());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult() == Status.OK_STATUS) {
                    BuildDetails testResults = ((RetrieveTestResultsJob)event.getJob()).getBuildDetails();
                    if (testResults != null) {
                        ShowTestResultsAction.this.showJUnitView(testResults, String.valueOf(build.getPlanKey()) + "-" + build.getNumber());
                    } else {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)ShowTestResultsAction.this.getText(), (String)("Retrieving test result for " + build.getPlanKey() + "-" + build.getNumber() + " failed. See Error Log for details."));
                            }
                        });
                    }
                }
            }
        });
        job.schedule();
    }

    boolean onUpdateSelection(EclipseBambooBuild eclipseBambooBuild) {
        BambooBuild build = eclipseBambooBuild.getBuild();
        return build.getTestsFailed() + build.getTestsPassed() > 0;
    }

    private void showJUnitView(final BuildDetails testResults, final String buildKey) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                new ShowTestResultsExecution().execute(testResults, buildKey);
            }
        });
    }

    private class ShowTestResultsExecution {
        private ShowTestResultsExecution() {
        }

        public void execute(BuildDetails testResults, String buildKey) {
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.bamboo.ui", "Error opening JUnit View. No active workbench window."));
                return;
            }
            try {
                IViewPart testsView = activeWorkbenchWindow.getActivePage().showView("com.atlassian.connector.eclipse.bamboo.ui.views.testResultView");
                if (testsView != null && testsView instanceof TestResultsView) {
                    ((TestResultsView)testsView).setTestsResult(buildKey, testResults);
                }
            }
            catch (PartInitException e) {
                StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.bamboo.ui", "Error opening JUnit View", (Throwable)e));
                return;
            }
        }
    }
}

