/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui;

import com.atlassian.connector.eclipse.internal.bamboo.core.BambooCorePlugin;
import com.atlassian.connector.eclipse.internal.bamboo.ui.notifications.BambooNotificationProvider;
import com.atlassian.connector.eclipse.internal.branding.ui.RuntimeUtil;
import com.atlassian.connector.eclipse.internal.commons.ui.MigrateToSecureStorageJob;
import com.atlassian.connector.eclipse.ui.commons.AtlassianUiUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryAdapter;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class BambooUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.atlassian.connector.eclipse.bamboo.ui";
    private static BambooUiPlugin plugin;
    private BambooNotificationProvider bambooNotificationProvider;
    private ActivateBambooViewIfNeededRepositoryListener repositoryListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
        repositoryManager.addListener((IRepositoryListener)BambooCorePlugin.getRepositoryConnector().getClientManager());
        if (!this.getPreferenceStore().getBoolean("secure_storage.migration.done") && !RuntimeUtil.suppressConfigurationWizards()) {
            MigrateToSecureStorageJob migrateJob = new MigrateToSecureStorageJob("bamboo");
            migrateJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    BambooUiPlugin.this.getPreferenceStore().setValue("secure_storage.migration.done", Boolean.TRUE.booleanValue());
                }
            });
            migrateJob.schedule();
        }
        UIJob job = new UIJob("Initializing Bamboo"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                BambooUiPlugin.this.bambooNotificationProvider = new BambooNotificationProvider();
                try {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IViewReference[] iViewReferenceArray = activePage.getViewReferences();
                    int n = iViewReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IViewReference view = iViewReferenceArray[n2];
                        if (view.getId().equals("com.atlassian.connector.eclipse.bamboo.ui.plans")) {
                            activePage.showView("com.atlassian.connector.eclipse.bamboo.ui.plans", null, 3);
                        }
                        ++n2;
                    }
                }
                catch (PartInitException partInitException) {
                    StatusHandler.log((IStatus)new Status(4, BambooUiPlugin.PLUGIN_ID, "Could not initialize Bamboo view."));
                }
                BambooCorePlugin.getBuildPlanManager().initializeScheduler(TasksUi.getRepositoryManager());
                return Status.OK_STATUS;
            }
        };
        this.repositoryListener = new ActivateBambooViewIfNeededRepositoryListener();
        repositoryManager.addListener((IRepositoryListener)this.repositoryListener);
        job.schedule(10000L);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.bambooNotificationProvider != null) {
            this.bambooNotificationProvider.dispose();
        }
        if (this.repositoryListener != null) {
            IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
            repositoryManager.removeListener((IRepositoryListener)this.repositoryListener);
            this.repositoryListener = null;
        }
        super.stop(context);
    }

    public static BambooUiPlugin getDefault() {
        return plugin;
    }

    private final class ActivateBambooViewIfNeededRepositoryListener
    extends TaskRepositoryAdapter {
        private ActivateBambooViewIfNeededRepositoryListener() {
        }

        public void repositoryAdded(TaskRepository repository) {
            if (repository.getConnectorKind().equals("bamboo") && !RuntimeUtil.suppressConfigurationWizards()) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        AtlassianUiUtil.ensureViewIsVisible((String)"com.atlassian.connector.eclipse.bamboo.ui.plans");
                    }
                });
            }
        }
    }
}

