/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.ui.actions;

import com.atlassian.connector.eclipse.ui.commons.AtlassianUiUtil;
import com.atlassian.connector.eclipse.ui.commons.IEditorResource;
import com.atlassian.connector.eclipse.ui.commons.ResourceEditorBean;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceAction
extends BaseSelectionListenerAction
implements IActionDelegate {
    private IWorkbenchWindow workbenchWindow;
    private List<ResourceEditorBean> selectionData;

    protected AbstractResourceAction(String text) {
        super(text);
    }

    protected List<ResourceEditorBean> getSelectionData() {
        return this.selectionData;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.workbenchWindow = window;
    }

    public void run(IAction action) {
        if (this.selectionData != null && this.selectionData.get(0) != null) {
            this.processResources(this.selectionData, WorkbenchUtil.getShell());
        }
    }

    private List<ResourceEditorBean> getData(ISelection selection) {
        ArrayList<ResourceEditorBean> ret = new ArrayList<ResourceEditorBean>();
        if (selection instanceof IStructuredSelection) {
            Object[] selectedObjects;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = selectedObjects = structuredSelection.toArray();
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObject = objectArray[n2];
                if (selectedObject instanceof IEditorResource) {
                    IEditorResource a = (IEditorResource)selectedObject;
                    ret.add(new ResourceEditorBean(a.getResource(), a.getLineRange()));
                } else if (structuredSelection.getFirstElement() instanceof IAdaptable) {
                    IResource resource = null;
                    LineRange lineRange = null;
                    resource = (IResource)((IAdaptable)structuredSelection.getFirstElement()).getAdapter(IResource.class);
                    lineRange = this.getJavaEditorSelection((ISelection)structuredSelection);
                    ret.add(new ResourceEditorBean(resource, lineRange));
                }
                ++n2;
            }
        } else {
            IEditorInput editorInput;
            IEditorPart activeEditor = this.getActiveEditor();
            if (activeEditor != null && (editorInput = this.getEditorInputFromSelection(selection)) != null) {
                IResource resource = null;
                LineRange lineRange = null;
                resource = (IResource)editorInput.getAdapter(IResource.class);
                lineRange = AtlassianUiUtil.getSelectedLineNumberRangeFromEditorInput(activeEditor, activeEditor.getEditorInput());
                ret.add(new ResourceEditorBean(resource, lineRange));
            }
        }
        return ret;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selectionData = this.getData((ISelection)selection);
        return super.updateSelection(selection);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
        } else {
            this.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        }
        action.setEnabled(this.isEnabled());
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchWindow window = this.workbenchWindow;
        if (window == null) {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        if (window != null && window.getActivePage() != null) {
            return window.getActivePage().getActiveEditor();
        }
        return null;
    }

    private IEditorInput getEditorInputFromSelection(ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).getFirstElement() instanceof IEditorInput) {
            return (IEditorInput)structuredSelection.getFirstElement();
        }
        return null;
    }

    @Nullable
    private LineRange getJavaEditorSelection(ISelection selection) {
        IEditorPart editorPart = this.getActiveEditor();
        IEditorInput editorInput = this.getEditorInputFromSelection(selection);
        if (editorInput != null && editorPart != null) {
            return AtlassianUiUtil.getSelectedLineNumberRangeFromEditorInput(editorPart, editorInput);
        }
        return null;
    }

    protected abstract void processResources(@NotNull List<ResourceEditorBean> var1, Shell var2);
}

