/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.config;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.jms.config.AbstractJmsListenerEndpoint;
import org.springframework.jms.listener.MessageListenerContainer;
import org.springframework.jms.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MethodJmsListenerEndpoint
extends AbstractJmsListenerEndpoint {
    private Object bean;
    private Method method;
    private MessageHandlerMethodFactory messageHandlerMethodFactory;

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    @Override
    protected MessagingMessageListenerAdapter createMessageListener(MessageListenerContainer container) {
        MessageConverter messageConverter;
        Assert.state((this.messageHandlerMethodFactory != null ? 1 : 0) != 0, (String)"Could not create message listener - MessageHandlerMethodFactory not set");
        MessagingMessageListenerAdapter messageListener = this.createMessageListenerInstance();
        InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(this.getBean(), this.getMethod());
        messageListener.setHandlerMethod(invocableHandlerMethod);
        String responseDestination = this.getDefaultResponseDestination();
        if (StringUtils.hasText((String)responseDestination)) {
            if (container.isPubSubDomain()) {
                messageListener.setDefaultResponseTopicName(responseDestination);
            } else {
                messageListener.setDefaultResponseQueueName(responseDestination);
            }
        }
        if ((messageConverter = container.getMessageConverter()) != null) {
            messageListener.setMessageConverter(messageConverter);
        }
        return messageListener;
    }

    protected MessagingMessageListenerAdapter createMessageListenerInstance() {
        return new MessagingMessageListenerAdapter();
    }

    private String getDefaultResponseDestination() {
        Method specificMethod = this.getMostSpecificMethod();
        SendTo ann = (SendTo)AnnotationUtils.getAnnotation((Method)specificMethod, SendTo.class);
        if (ann != null) {
            Object[] destinations = ann.value();
            if (destinations.length != 1) {
                throw new IllegalStateException("Invalid @" + SendTo.class.getSimpleName() + " annotation on '" + specificMethod + "' one destination must be set (got " + Arrays.toString(destinations) + ")");
            }
            return destinations[0];
        }
        return null;
    }

    private Method getMostSpecificMethod() {
        if (AopUtils.isAopProxy((Object)this.bean)) {
            Class target = AopProxyUtils.ultimateTargetClass((Object)this.bean);
            return AopUtils.getMostSpecificMethod((Method)this.getMethod(), (Class)target);
        }
        return this.getMethod();
    }

    @Override
    protected StringBuilder getEndpointDescription() {
        return super.getEndpointDescription().append(" | bean='").append(this.bean).append("'").append(" | method='").append(this.method).append("'");
    }
}

