/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.design;

import com.github.sevntu.checkstyle.Utils;
import com.google.common.collect.ImmutableSet;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Set;

public class AvoidConditionInversionCheck
extends Check {
    public static final String MSG_KEY = "avoid.condition.inversion";
    private static final Set<Integer> relationalOperatorsSet = ImmutableSet.of((Object)117, (Object)119, (Object)118, (Object)120, (Object)116, (Object)115, (Object[])new Integer[0]);
    private static final Set<Integer> relationalAndConditionalOperatorsSet = new ImmutableSet.Builder().addAll(relationalOperatorsSet).add((Object)110).add((Object)111).build();
    private boolean applyOnlyToRelationalOperands = false;

    public void setApplyOnlyToRelationalOperands(boolean applyOnlyToRelationalOperands) {
        this.applyOnlyToRelationalOperands = applyOnlyToRelationalOperands;
    }

    public int[] getDefaultTokens() {
        return new int[]{88, 83, 84, 85, 36};
    }

    public void visitToken(DetailAST ast) {
        DetailAST expressionAst = ast.findFirstToken(28);
        switch (ast.getType()) {
            case 88: {
                DetailAST inversionAst;
                if (AvoidConditionInversionCheck.isEmptyReturn(ast) || !this.isAvoidableInversion(inversionAst = AvoidConditionInversionCheck.getInversion(expressionAst))) break;
                this.log(inversionAst);
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                DetailAST invertedAst = AvoidConditionInversionCheck.getInversion(expressionAst);
                if (!this.isAvoidableInversion(invertedAst)) break;
                this.log(invertedAst);
                break;
            }
            case 36: {
                DetailAST inversionAst;
                if (AvoidConditionInversionCheck.isEmptyForCondition(ast) || !this.isAvoidableInversion(inversionAst = AvoidConditionInversionCheck.getInversion(expressionAst))) break;
                this.log(inversionAst);
                break;
            }
            default: {
                Utils.reportInvalidToken(ast.getType());
            }
        }
    }

    private static boolean isEmptyReturn(DetailAST returnAst) {
        return returnAst.findFirstToken(28) == null;
    }

    private static boolean isEmptyForCondition(DetailAST forConditionAst) {
        return forConditionAst.getFirstChild() == null;
    }

    private static DetailAST getInversion(DetailAST expressionAst) {
        return expressionAst.findFirstToken(132);
    }

    private boolean isAvoidableInversion(DetailAST inversionAst) {
        return inversionAst != null && !this.isSkipCondition(inversionAst);
    }

    private boolean isSkipCondition(DetailAST inversionConditionAst) {
        return this.applyOnlyToRelationalOperands && !AvoidConditionInversionCheck.containsRelationalOperandsOnly(inversionConditionAst) || !AvoidConditionInversionCheck.containsConditionalOrRelationalOperands(inversionConditionAst);
    }

    private static boolean containsRelationalOperandsOnly(DetailAST inversionConditionAst) {
        boolean result = true;
        DetailAST operatorInInversionAst = inversionConditionAst.getFirstChild().getNextSibling();
        if (operatorInInversionAst != null && !relationalOperatorsSet.contains(operatorInInversionAst.getType())) {
            for (DetailAST currentNode = operatorInInversionAst.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
                if (currentNode.getType() != 58 && AvoidConditionInversionCheck.isRelationalOperand(currentNode)) continue;
                result = false;
            }
        }
        return result;
    }

    private static boolean isRelationalOperand(DetailAST operandAst) {
        return operandAst.getFirstChild() == null || relationalOperatorsSet.contains(operandAst.getType());
    }

    private static boolean containsConditionalOrRelationalOperands(DetailAST inversionAst) {
        boolean result = false;
        for (DetailAST currentNodeAst = inversionAst.getFirstChild(); currentNodeAst != null; currentNodeAst = currentNodeAst.getNextSibling()) {
            if (!relationalAndConditionalOperatorsSet.contains(currentNodeAst.getType())) continue;
            result = true;
        }
        return result;
    }

    private void log(DetailAST inversionAst) {
        this.log(inversionAst.getLineNo(), MSG_KEY, new Object[0]);
    }
}

