/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.autowire.internal.provider;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.ws.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.ide.eclipse.beans.core.autowire.AutowireBeanReference;
import org.springframework.ide.eclipse.beans.core.autowire.IAutowireDependencyResolver;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.IInjectionMetadataProvider;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.IInjectionMetadataProviderProblemReporter;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.InjectionMetadata;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.PassThroughProblemReporter;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanReference;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class CommonAnnnotationInjectionMetadataProvider
implements IInjectionMetadataProvider {
    private static String webServiceRefClassName = "javax.xml.ws.WebServiceRef";
    private static String ejbRefClassName = "javax.ejb.EJB";
    private static String resourceClassName = "javax.annotation.Resource";
    private final Set<String> ignoredResourceTypes = new HashSet<String>(1);
    private boolean fallbackToDefaultTypeMatch = true;
    private IInjectionMetadataProviderProblemReporter problemReporter = new PassThroughProblemReporter();
    private final transient Map<Class<?>, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap();

    public CommonAnnnotationInjectionMetadataProvider() {
        this.ignoreResourceType("javax.xml.ws.WebServiceContext");
    }

    public void setProblemReporter(IInjectionMetadataProviderProblemReporter problemReporter) {
        this.problemReporter = problemReporter;
    }

    public void ignoreResourceType(String resourceType) {
        Assert.notNull((Object)resourceType, (String)"Ignored resource type must not be null");
        this.ignoredResourceTypes.add(resourceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InjectionMetadata findAutowiringMetadata(final Class<?> clazz) {
        InjectionMetadata metadata = this.injectionMetadataCache.get(clazz);
        if (metadata == null) {
            Map<Class<?>, InjectionMetadata> map = this.injectionMetadataCache;
            synchronized (map) {
                Class<?> annotationClass = null;
                try {
                    annotationClass = clazz.getClassLoader().loadClass(resourceClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    annotationClass = null;
                }
                final Class<?> resourceClass = annotationClass;
                try {
                    annotationClass = clazz.getClassLoader().loadClass(webServiceRefClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    annotationClass = null;
                }
                final Class<?> webServiceRefClass = annotationClass;
                try {
                    annotationClass = clazz.getClassLoader().loadClass(ejbRefClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    annotationClass = null;
                }
                final Class<?> ejbRefClass = annotationClass;
                metadata = this.injectionMetadataCache.get(clazz);
                if (metadata == null) {
                    final InjectionMetadata newMetadata = new InjectionMetadata();
                    ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                        public void doWith(Field field) {
                            if (webServiceRefClass != null && field.isAnnotationPresent(webServiceRefClass)) {
                                if (Modifier.isStatic(field.getModifiers())) {
                                    CommonAnnnotationInjectionMetadataProvider.this.problemReporter.error("@WebServiceRef annotation is not supported on static fields", field, new ValidationProblemAttribute[0]);
                                    return;
                                }
                                newMetadata.addInjectedField(new WebServiceRefElement(field, null, webServiceRefClass));
                            } else if (ejbRefClass != null && field.isAnnotationPresent(ejbRefClass)) {
                                if (Modifier.isStatic(field.getModifiers())) {
                                    CommonAnnnotationInjectionMetadataProvider.this.problemReporter.error("@EJB annotation is not supported on static fields", field, new ValidationProblemAttribute[0]);
                                    return;
                                }
                                newMetadata.addInjectedField(new EjbRefElement(field, null, ejbRefClass));
                            } else if (field.isAnnotationPresent(resourceClass)) {
                                if (Modifier.isStatic(field.getModifiers())) {
                                    CommonAnnnotationInjectionMetadataProvider.this.problemReporter.error("@Resource annotation is not supported on static fields", field, new ValidationProblemAttribute[0]);
                                    return;
                                }
                                if (!CommonAnnnotationInjectionMetadataProvider.this.ignoredResourceTypes.contains(field.getType().getName())) {
                                    newMetadata.addInjectedField(new ResourceElement(field, null, resourceClass));
                                }
                            }
                        }
                    });
                    ReflectionUtils.doWithMethods(clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                        public void doWith(Method method) {
                            if (webServiceRefClass != null && method.isAnnotationPresent(webServiceRefClass) && method.equals(ClassUtils.getMostSpecificMethod((Method)method, (Class)clazz))) {
                                if (Modifier.isStatic(method.getModifiers())) {
                                    CommonAnnnotationInjectionMetadataProvider.this.problemReporter.error("@WebServiceRef annotation is not supported on static methods", method, new ValidationProblemAttribute[0]);
                                    return;
                                }
                                if (method.getParameterTypes().length != 1) {
                                    CommonAnnnotationInjectionMetadataProvider.this.problemReporter.error("@WebServiceRef annotation requires a single-arg method", method, new ValidationProblemAttribute[0]);
                                    return;
                                }
                                PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)method);
                                newMetadata.addInjectedMethod(new WebServiceRefElement(method, pd, webServiceRefClass));
                            } else if (ejbRefClass != null && method.isAnnotationPresent(ejbRefClass) && method.equals(ClassUtils.getMostSpecificMethod((Method)method, (Class)clazz))) {
                                if (Modifier.isStatic(method.getModifiers())) {
                                    CommonAnnnotationInjectionMetadataProvider.this.problemReporter.error("@EJB annotation is not supported on static methods", method, new ValidationProblemAttribute[0]);
                                    return;
                                }
                                if (method.getParameterTypes().length != 1) {
                                    CommonAnnnotationInjectionMetadataProvider.this.problemReporter.error("@EJB annotation requires a single-arg method", method, new ValidationProblemAttribute[0]);
                                    return;
                                }
                                PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)method);
                                newMetadata.addInjectedMethod(new EjbRefElement(method, pd, ejbRefClass));
                            } else if (method.isAnnotationPresent(resourceClass) && method.equals(ClassUtils.getMostSpecificMethod((Method)method, (Class)clazz))) {
                                if (Modifier.isStatic(method.getModifiers())) {
                                    CommonAnnnotationInjectionMetadataProvider.this.problemReporter.error("@Resource annotation is not supported on static methods", method, new ValidationProblemAttribute[0]);
                                    return;
                                }
                                Class<?>[] paramTypes = method.getParameterTypes();
                                if (paramTypes.length != 1) {
                                    CommonAnnnotationInjectionMetadataProvider.this.problemReporter.error("@Resource annotation requires a single-arg method", method, new ValidationProblemAttribute[0]);
                                    return;
                                }
                                if (!CommonAnnnotationInjectionMetadataProvider.this.ignoredResourceTypes.contains(paramTypes[0].getName())) {
                                    PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)method);
                                    newMetadata.addInjectedMethod(new ResourceElement(method, pd, resourceClass));
                                }
                            }
                        }
                    });
                    metadata = newMetadata;
                    this.injectionMetadataCache.put(clazz, metadata);
                }
            }
        }
        return metadata;
    }

    private class EjbRefElement
    extends LookupElement {
        private String beanName;

        public EjbRefElement(Member member, PropertyDescriptor pd, Class<? extends Annotation> annotationClass) {
            super(member, pd, annotationClass);
        }

        @Override
        protected void initAnnotation(AnnotatedElement ae, Class<? extends Annotation> annotationClass) {
            Class<?> resourceType;
            Annotation resource = ae.getAnnotation(annotationClass);
            String resourceBeanName = (String)AnnotationUtils.getValue((Annotation)resource, (String)"beanName");
            String resourceName = (String)AnnotationUtils.getValue((Annotation)resource, (String)"name");
            boolean bl = this.isDefaultName = !StringUtils.hasLength((String)resourceName);
            if (this.isDefaultName) {
                resourceName = this.member.getName();
                if (this.member instanceof Method && resourceName.startsWith("set") && resourceName.length() > 3) {
                    resourceName = Introspector.decapitalize(resourceName.substring(3));
                }
            }
            if ((resourceType = (Class<?>)AnnotationUtils.getValue((Annotation)resource, (String)"beanInterface")) != null && !Object.class.equals((Object)resourceType)) {
                this.checkResourceType(resourceType);
            } else {
                resourceType = this.getResourceType();
            }
            this.beanName = resourceBeanName;
            this.name = resourceName;
            this.lookupType = resourceType;
            this.mappedName = (String)AnnotationUtils.getValue((Annotation)resource, (String)"mappedName");
        }

        @Override
        public Set<IBeanReference> getBeanReferences(IBean bean, IBeansModelElement context, IAutowireDependencyResolver resolver) {
            BeanDefinition bd = BeansModelUtils.getMergedBeanDefinition((IBean)bean, (IModelElement)context);
            if (!this.shouldSkip(bd) && StringUtils.hasLength((String)this.beanName)) {
                if (resolver.containsBean(this.beanName)) {
                    String[] matchingBeans;
                    String[] stringArray = matchingBeans = resolver.getBeansForType(this.lookupType);
                    int n = matchingBeans.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String matchingBen = stringArray[n2];
                        if (this.beanName.equals(matchingBen)) {
                            AutowireBeanReference ref = new AutowireBeanReference((ISourceModelElement)bean, (BeanReference)new RuntimeBeanReference(matchingBen));
                            if (this.getMember() instanceof Field) {
                                ref.setSource((Field)this.getMember());
                            } else {
                                ref.setSource(this.getMember(), 0);
                            }
                            return Collections.singleton(ref);
                        }
                        ++n2;
                    }
                } else if (this.isDefaultName) {
                    StringUtils.hasLength((String)this.mappedName);
                }
            }
            return super.getBeanReferences(bean, context, resolver);
        }
    }

    protected abstract class LookupElement
    extends InjectionMetadata.InjectedElement {
        protected String name;
        protected boolean isDefaultName;
        protected Class<?> lookupType;
        protected String mappedName;

        public LookupElement(Member member, PropertyDescriptor pd, Class<? extends Annotation> annotationClass) {
            super(member, pd);
            this.isDefaultName = false;
            this.initAnnotation((AnnotatedElement)((Object)member), annotationClass);
        }

        protected abstract void initAnnotation(AnnotatedElement var1, Class<? extends Annotation> var2);

        public final String getName() {
            return this.name;
        }

        public final Class<?> getLookupType() {
            return this.lookupType;
        }

        @Override
        public Set<IBeanReference> getBeanReferences(IBean bean, IBeansModelElement context, IAutowireDependencyResolver resolver) {
            BeanDefinition bd = BeansModelUtils.getMergedBeanDefinition((IBean)bean, (IModelElement)context);
            if (!this.shouldSkip(bd)) {
                String[] matchingBeans;
                if (CommonAnnnotationInjectionMetadataProvider.this.fallbackToDefaultTypeMatch && this.isDefaultName && !resolver.containsBean(this.name)) {
                    return super.getBeanReferences(bean, context, resolver);
                }
                String[] stringArray = matchingBeans = resolver.getBeansForType(this.lookupType);
                int n = matchingBeans.length;
                int n2 = 0;
                while (n2 < n) {
                    String matchingBen = stringArray[n2];
                    if (this.name.equals(matchingBen) || Arrays.asList(resolver.getAliases(matchingBen)).contains(this.name)) {
                        AutowireBeanReference ref = new AutowireBeanReference((ISourceModelElement)bean, (BeanReference)new RuntimeBeanReference(matchingBen));
                        if (this.getMember() instanceof Field) {
                            ref.setSource((Field)this.getMember());
                        } else {
                            ref.setSource(this.getMember(), 0);
                        }
                        return Collections.singleton(ref);
                    }
                    ++n2;
                }
            }
            return Collections.emptySet();
        }

        @Override
        protected DependencyDescriptor[] getDependencyDescriptor(IAutowireDependencyResolver resolver) {
            if (this.getMember() instanceof Field) {
                return new DependencyDescriptor[]{new DependencyDescriptor((Field)this.getMember(), true)};
            }
            Method method = (Method)this.member;
            Class<?>[] paramTypes = method.getParameterTypes();
            DependencyDescriptor[] descriptors = new DependencyDescriptor[paramTypes.length];
            int i = 0;
            while (i < paramTypes.length) {
                MethodParameter methodParam = new MethodParameter(method, i);
                descriptors[i] = new DependencyDescriptor(methodParam, true);
                ++i;
            }
            return descriptors;
        }

        @Override
        public boolean shouldSkip(BeanDefinition bd) {
            return this.checkPropertySkipping((PropertyValues)bd.getPropertyValues());
        }
    }

    private class ResourceElement
    extends LookupElement {
        public ResourceElement(Member member, PropertyDescriptor pd, Class<? extends Annotation> annotationClass) {
            super(member, pd, annotationClass);
        }

        @Override
        protected void initAnnotation(AnnotatedElement ae, Class<? extends Annotation> annotationClass) {
            Annotation resource = ae.getAnnotation(annotationClass);
            String resourceName = (String)AnnotationUtils.getValue((Annotation)resource, (String)"name");
            Class<?> resourceType = (Class<?>)AnnotationUtils.getValue((Annotation)resource, (String)"type");
            boolean bl = this.isDefaultName = !StringUtils.hasLength((String)resourceName);
            if (this.isDefaultName) {
                resourceName = this.member.getName();
                if (this.member instanceof Method && resourceName.startsWith("set") && resourceName.length() > 3) {
                    resourceName = Introspector.decapitalize(resourceName.substring(3));
                }
            }
            if (resourceType != null && !Object.class.equals((Object)resourceType)) {
                this.checkResourceType(resourceType);
            } else {
                resourceType = this.getResourceType();
            }
            this.name = resourceName;
            this.lookupType = resourceType;
            this.mappedName = (String)AnnotationUtils.getValue((Annotation)resource, (String)"mappedName");
        }

        @Override
        public Set<IBeanReference> getBeanReferences(IBean bean, IBeansModelElement context, IAutowireDependencyResolver resolver) {
            BeanDefinition bd = BeansModelUtils.getMergedBeanDefinition((IBean)bean, (IModelElement)context);
            if (!this.shouldSkip(bd)) {
                if (StringUtils.hasLength((String)this.mappedName)) {
                    String[] matchingBeans;
                    String[] stringArray = matchingBeans = resolver.getBeansForType(this.lookupType);
                    int n = matchingBeans.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String matchingBen = stringArray[n2];
                        if (this.mappedName.equals(matchingBen)) {
                            AutowireBeanReference ref = new AutowireBeanReference((ISourceModelElement)bean, (BeanReference)new RuntimeBeanReference(matchingBen));
                            if (this.getMember() instanceof Field) {
                                ref.setSource((Field)this.getMember());
                            } else {
                                ref.setSource(this.getMember(), 0);
                            }
                            return Collections.singleton(ref);
                        }
                        ++n2;
                    }
                } else {
                    return super.getBeanReferences(bean, context, resolver);
                }
            }
            return Collections.emptySet();
        }
    }

    private class WebServiceRefElement
    extends LookupElement {
        public WebServiceRefElement(Member member, PropertyDescriptor pd, Class<? extends Annotation> annotationClass) {
            super(member, pd, annotationClass);
        }

        @Override
        protected void initAnnotation(AnnotatedElement ae, Class<? extends Annotation> annotationClass) {
            Annotation resource = ae.getAnnotation(annotationClass);
            String resourceName = (String)AnnotationUtils.getValue((Annotation)resource, (String)"name");
            Class<?> resourceType = (Class<?>)AnnotationUtils.getValue((Annotation)resource, (String)"type");
            boolean bl = this.isDefaultName = !StringUtils.hasLength((String)resourceName);
            if (this.isDefaultName) {
                resourceName = this.member.getName();
                if (this.member instanceof Method && resourceName.startsWith("set") && resourceName.length() > 3) {
                    resourceName = Introspector.decapitalize(resourceName.substring(3));
                }
            }
            if (resourceType != null && !Object.class.equals((Object)resourceType)) {
                this.checkResourceType(resourceType);
            } else {
                resourceType = this.getResourceType();
            }
            this.name = resourceName;
            this.lookupType = Service.class.isAssignableFrom(resourceType) ? resourceType : (!Object.class.equals(AnnotationUtils.getValue((Annotation)resource, (String)"value")) ? (Class)AnnotationUtils.getValue((Annotation)resource, (String)"value") : Service.class);
            this.mappedName = (String)AnnotationUtils.getValue((Annotation)resource, (String)"mappedName");
        }
    }
}

