/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.monitor.usage.wizards;

import com.atlassian.connector.eclipse.internal.monitor.core.operations.UsageDataUploadJob;
import com.atlassian.connector.eclipse.internal.monitor.usage.Messages;
import com.atlassian.connector.eclipse.internal.monitor.usage.wizards.UsageUploadWizardPage;
import com.atlassian.connector.eclipse.monitor.core.MonitorCorePlugin;
import java.io.File;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class UsageSubmissionWizard
extends Wizard
implements INewWizard {
    public static final String LOG = "log";
    public static final String QUESTIONAIRE = "questionaire";
    public static final String BACKGROUND = "background";
    public static final int HTTP_SERVLET_RESPONSE_SC_OK = 200;
    public static final int SIZE_OF_INT = 8;
    private final boolean failed = false;
    private final File monitorFile = MonitorCorePlugin.getDefault().getMonitorLogFile();
    private UsageUploadWizardPage uploadPage;

    public UsageSubmissionWizard() {
        this.setTitles();
        this.init();
    }

    private void setTitles() {
        super.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.atlassian.connector.eclipse.monitor.ui", (String)"icons/wizban/banner-user.gif"));
        super.setWindowTitle(Messages.UsageSubmissionWizard_title);
    }

    private void init() {
        this.setNeedsProgressMonitor(true);
        this.uploadPage = new UsageUploadWizardPage(this);
        super.setForcePreviousAndNextButtons(true);
    }

    public boolean performFinish() {
        UsageDataUploadJob j = new UsageDataUploadJob(true);
        j.setPriority(50);
        j.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    return;
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openInformation((Shell)WorkbenchUtil.getShell(), (String)"Usage Data Submission", (String)"Usage Data was uploaded. Thank you for participating!");
                    }
                });
            }
        });
        j.schedule();
        return true;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.uploadPage;
    }

    public UsageUploadWizardPage getUploadPage() {
        return this.uploadPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.addPage((IWizardPage)this.uploadPage);
    }

    public String getMonitorFileName() {
        return this.monitorFile.getAbsolutePath();
    }

    public boolean failed() {
        return false;
    }
}

