/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.workspace;

import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class ClasspathListenerManager {
    private ClasspathListener listener;
    private MyListener myListener;

    public ClasspathListenerManager(ClasspathListener listener) {
        this.listener = listener;
        this.myListener = new MyListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.myListener, (int)1);
    }

    public void dispose() {
        if (this.myListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.myListener);
            this.myListener = null;
        }
    }

    public static interface ClasspathListener {
        public void classpathChanged(IJavaProject var1);
    }

    private class MyListener
    implements IElementChangedListener {
        private MyListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            this.visit(event.getDelta());
        }

        private void visit(IJavaElementDelta delta) {
            IJavaElement el = delta.getElement();
            switch (el.getElementType()) {
                case 1: {
                    this.visitChildren(delta);
                    break;
                }
                case 2: {
                    if (!this.isClasspathChanged(delta.getFlags())) break;
                    ClasspathListenerManager.this.listener.classpathChanged((IJavaProject)el);
                    break;
                }
            }
        }

        private boolean isClasspathChanged(int flags) {
            return (flags & 0x220000) != 0;
        }

        public void visitChildren(IJavaElementDelta delta) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta c = iJavaElementDeltaArray[n2];
                this.visit(c);
                ++n2;
            }
        }
    }
}

