/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.util;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.springsource.ide.eclipse.commons.frameworks.core.FrameworkCoreActivator;

public class Gtk3Check {
    public static final boolean isGTK3 = Gtk3Check.isGTK3();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isGTK3() {
        if (!"linux".equals(Platform.getOS())) {
            return false;
        }
        try {
            String lib;
            Bundle bundle = Platform.getBundle((String)"org.eclipse.swt");
            BundleWiring bw = (BundleWiring)bundle.adapt(BundleWiring.class);
            ClassLoader cl = bw.getClassLoader();
            Vector<String> libs = Gtk3Check.getNativeLibs(cl);
            Iterator iterator = libs.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(lib = (String)iterator.next()).contains("swt-pi3-gtk"));
            return true;
        }
        catch (Throwable e) {
            FrameworkCoreActivator.log(e);
            return true;
        }
    }

    private static Vector<String> getNativeLibs(ClassLoader classLoader) throws Exception {
        Field field = ClassLoader.class.getDeclaredField("loadedLibraryNames");
        field.setAccessible(true);
        return (Vector)field.get(classLoader);
    }
}

