/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.internal.model;

import java.lang.reflect.Method;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.springframework.beans.BeanUtils;
import org.springframework.ide.eclipse.aop.core.internal.model.BeanAspectDefinitionElementFactory;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IAspectDefinition;
import org.springframework.ide.eclipse.core.java.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BeanAspectDefinition
implements IAspectDefinition,
IAdaptable,
IPersistableElement {
    protected String adviceMethodName;
    protected String[] adviceMethodParameterTypes = new String[0];
    protected String[] argNames;
    protected String aspectClassName;
    protected int aspectStartLineNumber = -1;
    protected int aspectEndLineNumber = -1;
    protected String aspectName = "";
    protected IResource file;
    protected boolean isProxyTargetClass = false;
    protected String pointcutExpressionString = null;
    protected String returning;
    protected String throwing;
    protected IAopReference.ADVICE_TYPE type;

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.adviceMethodName);
        hashCode += ObjectUtils.nullSafeHashCode((Object[])this.adviceMethodParameterTypes);
        hashCode += ObjectUtils.nullSafeHashCode((Object[])this.argNames);
        hashCode += ObjectUtils.nullSafeHashCode((Object)this.aspectClassName);
        hashCode += this.aspectEndLineNumber;
        hashCode += ObjectUtils.nullSafeHashCode((Object)this.aspectName);
        hashCode += this.aspectStartLineNumber;
        hashCode += ObjectUtils.nullSafeHashCode((Object)this.returning);
        hashCode += ObjectUtils.nullSafeHashCode((Object)this.file);
        hashCode += ObjectUtils.nullSafeHashCode((Object)((Object)this.type));
        hashCode += ObjectUtils.nullSafeHashCode((Object)this.pointcutExpressionString);
        return 12 * (hashCode += ObjectUtils.nullSafeHashCode((Object)this.throwing));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeanAspectDefinition)) {
            return false;
        }
        BeanAspectDefinition that = (BeanAspectDefinition)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.adviceMethodName, (Object)that.adviceMethodName)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.adviceMethodParameterTypes, (Object)that.adviceMethodParameterTypes)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.argNames, (Object)that.argNames)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.aspectClassName, (Object)that.aspectClassName)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.aspectName, (Object)that.aspectName)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.aspectEndLineNumber, (Object)that.aspectEndLineNumber)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.aspectStartLineNumber, (Object)that.aspectStartLineNumber)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.returning, (Object)that.returning)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.file, (Object)that.file)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)((Object)this.type), (Object)((Object)that.type))) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.pointcutExpressionString, (Object)that.pointcutExpressionString)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.throwing, (Object)that.throwing);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPersistableElement.class)) {
            return this;
        }
        return null;
    }

    @Override
    public Method getAdviceMethod() {
        try {
            Class aspectClass = ClassUtils.loadClass((String)this.aspectClassName);
            Method method = BeanUtils.resolveSignature((String)this.adviceMethodName, (Class)aspectClass);
            return method;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public String getAdviceMethodName() {
        return this.adviceMethodName;
    }

    @Override
    public String[] getAdviceMethodParameterTypes() {
        return this.adviceMethodParameterTypes;
    }

    @Override
    public String[] getArgNames() {
        return this.argNames;
    }

    @Override
    public String getAspectClassName() {
        return this.aspectClassName;
    }

    @Override
    public int getAspectStartLineNumber() {
        return this.aspectStartLineNumber;
    }

    @Override
    public String getAspectName() {
        return this.aspectName;
    }

    public String getFactoryId() {
        return BeanAspectDefinitionElementFactory.FACTORY_ID;
    }

    @Override
    public String getPointcutExpression() {
        return this.pointcutExpressionString;
    }

    @Override
    public IResource getResource() {
        return this.file;
    }

    @Override
    public String getReturning() {
        return this.returning;
    }

    @Override
    public String getThrowing() {
        return this.throwing;
    }

    @Override
    public IAopReference.ADVICE_TYPE getType() {
        return this.type;
    }

    @Override
    public boolean isProxyTargetClass() {
        return this.isProxyTargetClass;
    }

    public void saveState(IMemento memento) {
        memento.putString("advice-method-name", this.adviceMethodName);
        memento.putString("advice-class-name", this.aspectClassName);
        if (this.adviceMethodParameterTypes != null && this.adviceMethodParameterTypes.length > 0) {
            memento.putString("advice-method-parameter-types", StringUtils.arrayToCommaDelimitedString((Object[])this.adviceMethodParameterTypes));
        }
        memento.putString("aspect-name", this.aspectName);
        memento.putString("pointcut-expression", this.pointcutExpressionString);
        memento.putString("returning", this.returning);
        memento.putString("throwing", this.throwing);
        if (this.argNames != null && this.argNames.length > 0) {
            memento.putString("arg-names", StringUtils.arrayToCommaDelimitedString((Object[])this.argNames));
        }
        memento.putInteger("aspect-start-line-number", this.aspectStartLineNumber);
        memento.putInteger("aspect-end-line-number", this.aspectEndLineNumber);
        if (this.file != null) {
            memento.putString("file", this.file.getFullPath().toString());
        }
        memento.putString("proxy-target-class", Boolean.toString(this.isProxyTargetClass));
        memento.putString("advice-type", this.type.toString());
    }

    public void setAdviceMethodName(String adviceMethodName) {
        this.adviceMethodName = adviceMethodName;
    }

    public void setAdviceMethodParameterTypes(String[] params) {
        this.adviceMethodParameterTypes = params;
    }

    public void setArgNames(String[] argNames) {
        this.argNames = argNames;
    }

    public void setAspectClassName(String aspectClassName) {
        this.aspectClassName = aspectClassName;
    }

    public void setAspectStartLineNumber(int aspectLineNumber) {
        this.aspectStartLineNumber = aspectLineNumber;
    }

    public void setAspectEndLineNumber(int aspectLineNumber) {
        this.aspectEndLineNumber = aspectLineNumber;
    }

    public void setAspectName(String aspectName) {
        this.aspectName = !StringUtils.hasText((String)aspectName) ? "anonymous aspect" : aspectName;
    }

    public void setPointcutExpression(String expression) {
        this.pointcutExpressionString = expression;
    }

    public void setProxyTargetClass(boolean proxyTargetClass) {
        this.isProxyTargetClass = proxyTargetClass;
    }

    @Override
    public void setResource(IResource file) {
        this.file = file;
    }

    public void setReturning(String returning) {
        this.returning = returning;
    }

    public void setThrowing(String throwing) {
        this.throwing = throwing;
    }

    public void setType(IAopReference.ADVICE_TYPE type) {
        this.type = type;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Aspect definition");
        if (this.file != null) {
            buf.append(" [");
            buf.append(this.file.getFullPath().toFile());
            buf.append(":");
            buf.append(this.getAspectStartLineNumber());
            buf.append("]");
        }
        buf.append(" advise type [");
        IAopReference.ADVICE_TYPE type = this.getType();
        if (type == IAopReference.ADVICE_TYPE.AFTER) {
            buf.append("after");
        } else if (type == IAopReference.ADVICE_TYPE.AFTER_RETURNING) {
            buf.append("after-returning");
        } else if (type == IAopReference.ADVICE_TYPE.AFTER_THROWING) {
            buf.append("after-throwing");
        } else if (type == IAopReference.ADVICE_TYPE.BEFORE) {
            buf.append("before");
        } else if (type == IAopReference.ADVICE_TYPE.AROUND) {
            buf.append("after");
        } else if (type == IAopReference.ADVICE_TYPE.DECLARE_PARENTS) {
            buf.append("delcare parents");
        }
        buf.append("] advise [");
        buf.append(this.getAspectClassName());
        if (type != IAopReference.ADVICE_TYPE.DECLARE_PARENTS) {
            buf.append(".");
            buf.append(this.getAdviceMethodName());
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public int getAspectEndLineNumber() {
        return this.aspectEndLineNumber;
    }
}

