/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.ide.eclipse.aop.core.logging.AopLog;
import org.springframework.ide.eclipse.aop.core.model.IAopProject;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;

public class AopProject
implements IAopProject {
    private IJavaProject project;
    private Set<IAopReference> references = new CopyOnWriteArraySet<IAopReference>();
    protected final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    protected final Lock r = this.rwl.readLock();
    protected final Lock w = this.rwl.writeLock();

    public AopProject(IJavaProject project) {
        this.project = project;
    }

    @Override
    public void addAopReference(IAopReference reference) {
        AopLog.log(4, "Created AOP reference '" + reference + "'");
        try {
            this.w.lock();
            this.references.add(reference);
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void clearReferencesForResource(IResource resource) {
        ArrayList<IAopReference> toRemove = new ArrayList<IAopReference>();
        try {
            this.w.lock();
            for (IAopReference reference : this.references) {
                if (resource == null || !resource.equals((Object)reference.getDefinition().getResource())) continue;
                toRemove.add(reference);
            }
            this.references.removeAll(toRemove);
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public Set<IAopReference> getAllReferences() {
        return Collections.unmodifiableSet(this.references);
    }

    @Override
    public IJavaProject getProject() {
        return this.project;
    }

    @Override
    public Set<IAopReference> getReferencesForResource(IResource resource) {
        try {
            this.r.lock();
            LinkedHashSet<IAopReference> list = new LinkedHashSet<IAopReference>();
            for (IAopReference reference : this.references) {
                if (!reference.getResource().equals((Object)resource) && !reference.getDefinition().getResource().equals((Object)resource)) continue;
                list.add(reference);
            }
            LinkedHashSet<IAopReference> linkedHashSet = list;
            return linkedHashSet;
        }
        finally {
            this.r.unlock();
        }
    }
}

