/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules;

import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.SubflowState;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.WebflowValidationContext;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.ISubflowState;
import org.springframework.util.StringUtils;

public class SubflowStateValidationRule
implements IValidationRule<SubflowState, WebflowValidationContext> {
    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof SubflowState && context instanceof WebflowValidationContext;
    }

    public void validate(SubflowState state, WebflowValidationContext context, IProgressMonitor monitor) {
        if (!StringUtils.hasText((String)state.getFlow())) {
            if (context.isVersion1()) {
                context.error(state, "NO_FLOW_ATTRIBUTE", "Element 'subflow-state' requires unique '" + (context.isVersion1() ? "flow" : "subflow") + "' attribute", new ValidationProblemAttribute[0]);
            } else {
                IState parentState = context.getStateFromParentState(state.getAttribute(state.getNode(), "parent"));
                if (parentState == null || parentState instanceof ISubflowState && !StringUtils.hasText((String)((ISubflowState)parentState).getFlow())) {
                    context.error(state, "NO_FLOW_ATTRIBUTE", "Element 'subflow-state' requires unique '" + (context.isVersion1() ? "flow" : "subflow") + "' attribute", new ValidationProblemAttribute[0]);
                }
            }
        } else if (!WebflowModelUtils.getWebflowConfigNames(context.getWebflowConfig().getProject()).contains(state.getFlow()) && !WebflowModelUtils.getWebflowConfigNames(WebflowModelUtils.getWebflowState(state, true)).contains(state.getFlow())) {
            context.error(state, "FLOW_REFERENCE_INVALID", MessageUtils.format((String)"Referenced flow \"{0}\" cannot be found", (Object)state.getFlow()), new ValidationProblemAttribute[0]);
        }
    }
}

