/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules;

import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.EvaluationResult;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.WebflowValidationContext;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules.WebflowValidationRuleUtils;
import org.springframework.util.StringUtils;

public class EvaluationResultValidationRule
implements IValidationRule<EvaluationResult, WebflowValidationContext> {
    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof EvaluationResult && context instanceof WebflowValidationContext;
    }

    public void validate(EvaluationResult result, WebflowValidationContext context, IProgressMonitor monitor) {
        if (!StringUtils.hasText((String)result.getName())) {
            context.error(result, "NO_ATTRIBUTE_ATTRIBUTE", "Element  'evaluate-result' requires 'name' attribute", new ValidationProblemAttribute[0]);
        }
        if (StringUtils.hasText((String)result.getScope()) && !WebflowValidationRuleUtils.SCOPE_TYPES.contains(result.getScope())) {
            context.error(result, "NO_VALUE_ATTRIBUTE", MessageUtils.format((String)"Element 'set' requires 'value' attribute", (Object)result.getScope()), new ValidationProblemAttribute[0]);
        }
    }
}

