/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;

public class ListManager {
    private final List list;
    private final Button upButton;
    private final Button downButton;
    private final Button deleteButton;

    public ListManager(List theList, Button theUpButton, Button theDownButton, Button theDeleteButton) {
        this.list = theList;
        this.upButton = theUpButton;
        this.downButton = theDownButton;
        this.deleteButton = theDeleteButton;
        this.registerListeners();
        this.updateButtonStates();
    }

    private void registerListeners() {
        this.list.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ListManager.this.updateButtonStates();
            }
        });
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ListManager.this.shiftUp();
            }
        });
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ListManager.this.shiftDown();
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ListManager.this.delete();
            }
        });
    }

    private void shiftUp() {
        this.updateButtonStates();
    }

    private void shiftDown() {
        this.updateButtonStates();
    }

    private void delete() {
        int[] indices = this.list.getSelectionIndices();
        this.list.remove(indices);
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        if (!this.hasSelection()) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            return;
        }
        this.upButton.setEnabled(this.hasSelectionIndex(0));
        this.downButton.setEnabled(this.hasSelectionIndex(this.list.getItemCount() - 1));
        this.deleteButton.setEnabled(true);
    }

    private boolean hasSelection() {
        return this.list.getSelectionCount() > 0;
    }

    private boolean hasSelectionIndex(int index) {
        int[] nArray = this.list.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == index) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

