/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import net.sourceforge.pmd.eclipse.ui.actions.AbstractUIAction;
import net.sourceforge.pmd.eclipse.util.IOUtil;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ClearReviewsAction
extends AbstractUIAction
implements IResourceVisitor,
IViewActionDelegate {
    private static final Logger log = Logger.getLogger(ClearReviewsAction.class);
    private IProgressMonitor monitor;

    public void init(IViewPart view) {
        this.setActivePart(null, view.getSite().getPage().getActivePart());
    }

    public void run(IAction action) {
        log.info((Object)"Remove violation reviews requested.");
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            monitorDialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ClearReviewsAction.this.setMonitor(monitor);
                    ClearReviewsAction.this.clearReviews();
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            this.logError("Invocation Target Exception when removing violation reviews", e.getTargetException());
        }
        catch (InterruptedException e) {
            this.logError("Interrupted Exception when removing violation reviews", e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor;
    }

    protected void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    protected void monitorWorked() {
        if (this.getMonitor() != null) {
            this.getMonitor().worked(1);
        }
    }

    protected void monitorSubTask(String message) {
        if (this.getMonitor() != null) {
            this.getMonitor().subTask(message);
        }
    }

    protected void clearReviews() {
        try {
            ISelection selection;
            if (this.isViewPart() && (selection = this.targetSelection()) != null && selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (this.getMonitor() != null) {
                    this.getMonitor().beginTask(this.getString("monitor.remove_reviews"), -1);
                    for (Object object : structuredSelection) {
                        IResource resource = null;
                        if (object instanceof IMarker) {
                            resource = ((IMarker)object).getResource();
                        } else if (object instanceof IAdaptable) {
                            IAdaptable adaptable = (IAdaptable)object;
                            resource = (IResource)adaptable.getAdapter(IResource.class);
                        } else {
                            log.warn((Object)"The selected object is not adaptable");
                            log.debug((Object)("   -> selected object = " + object));
                        }
                        if (resource != null) {
                            resource.accept((IResourceVisitor)this);
                            continue;
                        }
                        log.warn((Object)"The selected object cannot adapt to a resource.");
                        log.debug((Object)("   -> selected object" + object));
                    }
                }
            }
            if (this.isEditorPart()) {
                IEditorInput editorInput = ((IEditorPart)this.targetPart()).getEditorInput();
                if (editorInput instanceof IFileEditorInput) {
                    ((IFileEditorInput)editorInput).getFile().accept((IResourceVisitor)this);
                } else {
                    log.debug((Object)("The kind of editor input is not supported. The editor input if of type: " + editorInput.getClass().getName()));
                }
            } else {
                log.debug((Object)("This action is not supported on this kind of part. This part type is: " + this.targetPartClassName()));
            }
        }
        catch (CoreException e) {
            this.logError("Core Exception when clearing violations reviews", e);
        }
    }

    private void clearReviews(IFile file) {
        this.monitorSubTask(file.getName());
        String updatedFileContent = this.removeReviews(file);
        if (updatedFileContent != null) {
            this.saveNewContent(file, updatedFileContent);
        }
        this.monitorWorked();
    }

    private static boolean isReviewable(IFile file) {
        if (AbstractDefaultCommand.isJavaFile(file)) {
            return true;
        }
        return file.getName().toLowerCase().endsWith(".jsp");
    }

    private String removeReviews(IFile file) {
        boolean noChange;
        ByteArrayOutputStream baos;
        block14: {
            if (!ClearReviewsAction.isReviewable(file)) {
                return null;
            }
            baos = new ByteArrayOutputStream();
            PrintWriter out = null;
            noChange = true;
            try {
                boolean comment = false;
                BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents()));
                out = new PrintWriter(baos);
                while (reader.ready()) {
                    String origLine = reader.readLine();
                    String line = origLine.trim();
                    if (line == null) break;
                    int index = origLine.indexOf("// NOPMD");
                    int quoteIndex = origLine.indexOf(34);
                    if (line.startsWith("/*")) {
                        if (line.indexOf("*/") == -1) {
                            comment = true;
                        }
                        out.println(origLine);
                        continue;
                    }
                    if (comment && line.indexOf("*/") != -1) {
                        comment = false;
                        out.println(origLine);
                        continue;
                    }
                    if (!comment && line.startsWith("// @PMD:REVIEWED:")) {
                        noChange = false;
                        continue;
                    }
                    if (!(comment || index == -1 || quoteIndex != -1 && quoteIndex < index && index < origLine.lastIndexOf(34))) {
                        noChange = false;
                        out.println(origLine.substring(0, index));
                        continue;
                    }
                    out.println(origLine);
                }
                out.flush();
            }
            catch (CoreException e) {
                this.logError("message.error.core_exception", e);
                IOUtil.closeQuietly(baos);
                IOUtil.closeQuietly(out);
                break block14;
            }
            catch (IOException e) {
                try {
                    this.logError("message.error.io_exception", e);
                    break block14;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtil.closeQuietly(baos);
                    IOUtil.closeQuietly(out);
                }
            }
            IOUtil.closeQuietly(baos);
            IOUtil.closeQuietly(out);
        }
        return noChange ? null : baos.toString();
    }

    private void saveNewContent(IFile file, String newContent) {
        try {
            file.setContents((InputStream)new ByteArrayInputStream(newContent.getBytes()), false, true, this.getMonitor());
        }
        catch (CoreException e) {
            this.logError("message.error.core_exception", e);
        }
    }

    public boolean visit(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            this.clearReviews((IFile)resource);
        }
        return resource instanceof IProject || resource instanceof IFolder;
    }
}

