/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import net.sourceforge.pmd.eclipse.runtime.cmd.BaseVisitor;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeltaVisitor
extends BaseVisitor
implements IResourceDeltaVisitor {
    private static final Logger log = Logger.getLogger(DeltaVisitor.class);

    public DeltaVisitor() {
    }

    public DeltaVisitor(IProgressMonitor monitor) {
        this.setMonitor(monitor);
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (this.isCanceled()) {
            return false;
        }
        switch (delta.getKind()) {
            case 1: {
                log.debug((Object)("Visiting added resource " + delta.getResource().getName()));
                this.visitAdded(delta.getResource());
                break;
            }
            case 4: {
                log.debug((Object)("Visiting changed resource " + delta.getResource().getName()));
                this.visitChanged(delta.getResource());
                break;
            }
            default: {
                log.debug((Object)("Resource " + delta.getResource().getName() + " not visited."));
            }
        }
        return true;
    }

    private void visitAdded(IResource resource) {
        this.reviewResource(resource);
    }

    private void visitChanged(IResource resource) {
        this.reviewResource(resource);
    }
}

