/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.tigris.subversion.subclipse.graph.Activator;
import org.tigris.subversion.subclipse.graph.cache.Branch;
import org.tigris.subversion.subclipse.graph.cache.Cache;
import org.tigris.subversion.subclipse.graph.cache.Graph;
import org.tigris.subversion.subclipse.graph.cache.Node;
import org.tigris.subversion.subclipse.graph.editors.BranchFigure;
import org.tigris.subversion.subclipse.graph.editors.NodeFigure;

public class GraphEditPart
extends AbstractGraphicalEditPart {
    private GraphicalViewer viewer;
    private Map branchMap = new HashMap();
    private Map nodeMap = new HashMap();
    private List connections = new ArrayList();
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();

    public GraphEditPart(GraphicalViewer viewer) {
        this.viewer = viewer;
    }

    protected IFigure createFigure() {
        Figure f = new Figure();
        f.setBackgroundColor(ColorConstants.white);
        f.setOpaque(true);
        XYLayout layout = new XYLayout();
        f.setLayoutManager((LayoutManager)layout);
        return f;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", null);
    }

    protected List getModelChildren() {
        Node node;
        Iterator nodeIter;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int showDeleted = store.getInt("RevisionGraph_showDeleted");
        Graph graph = (Graph)this.getModel();
        List paths = graph.getPaths();
        ArrayList<Branch> branches = new ArrayList<Branch>();
        Iterator iter = paths.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Node lastNode;
            Node firstNode;
            Branch branch = graph.getBranch((String)iter.next());
            if (branch.getNodes().size() == 1 && (firstNode = (Node)branch.getNodes().iterator().next()).getSource() != null && firstNode.getChildCount() == 0) {
                branch.setView(null);
                continue;
            }
            if (branch.getNodes().size() > 0 && (lastNode = (Node)branch.getNodes().get(branch.getNodes().size() - 1)).getAction() == 'D' && Cache.isEqualsOrParent(lastNode.getPath(), branch.getPath()) && (showDeleted == 2 || showDeleted == 0 && !this.isModified(branch)) && !graph.getRootPath().equals(branch.getPath())) {
                branch.setView(null);
                continue;
            }
            branch.setIndex(i++);
            branches.add(branch);
            int mod = branch.getIndex() % Activator.BG_COLORS.length;
            Color bgcolor = Activator.BG_COLORS[mod];
            Color fgcolor = Activator.FG_COLORS[mod];
            BranchFigure branchFigure = new BranchFigure(branch.getPath(), bgcolor, fgcolor);
            this.branchMap.put(branch.getPath(), branchFigure);
        }
        ArrayList<Node> nodeList = new ArrayList<Node>();
        iter = branches.iterator();
        while (iter.hasNext()) {
            Branch branch = (Branch)iter.next();
            nodeIter = branch.getNodes().iterator();
            while (nodeIter.hasNext()) {
                node = (Node)nodeIter.next();
                nodeList.add(node);
                int mod = branch.getIndex() % Activator.BG_COLORS.length;
                Color bgcolor = Activator.BG_COLORS[mod];
                Color fgcolor = Activator.FG_COLORS[mod];
                NodeFigure nodeFigure = new NodeFigure(node, bgcolor, fgcolor);
                this.nodeMap.put(node, nodeFigure);
            }
        }
        iter = branches.iterator();
        while (iter.hasNext()) {
            Branch branch = (Branch)iter.next();
            nodeIter = branch.getNodes().iterator();
            while (nodeIter.hasNext()) {
                NodeFigure target;
                node = (Node)nodeIter.next();
                NodeFigure nodeFigure = (NodeFigure)((Object)this.nodeMap.get(node));
                if (node.getParent() != null) {
                    target = (NodeFigure)((Object)this.nodeMap.get(node.getParent()));
                    if (target == null) continue;
                    this.makeConnection(this.getFigure(), (IFigure)target, nodeFigure);
                    continue;
                }
                if (node.getSource() != null) {
                    target = (NodeFigure)((Object)this.nodeMap.get(node.getSource()));
                    if (target == null) continue;
                    this.makeConnection(this.getFigure(), (IFigure)target, nodeFigure);
                    continue;
                }
                BranchFigure branchFigure = (BranchFigure)((Object)this.branchMap.get(branch.getPath()));
                this.makeConnection(this.getFigure(), (IFigure)branchFigure, nodeFigure);
            }
        }
        iter = branches.iterator();
        while (iter.hasNext()) {
            Branch branch = (Branch)iter.next();
            Iterator it = branch.getNodes().iterator();
            while (it.hasNext()) {
                node = (Node)it.next();
                List mergedRevisions = node.getMergedRevisions();
                if (mergedRevisions == null) continue;
                NodeFigure nodeFigure = (NodeFigure)((Object)this.nodeMap.get(node));
                Iterator iterator = node.getMergedRevisions().iterator();
                while (iterator.hasNext()) {
                    Node merged = (Node)iterator.next();
                    NodeFigure mergedView = (NodeFigure)((Object)this.nodeMap.get(merged));
                    if (mergedView == null) continue;
                    this.makeConnection(this.getFigure(), (IFigure)mergedView, nodeFigure, ColorConstants.red);
                }
            }
        }
        this.setConnectionVisibility();
        Object[] nodeArray = new Node[nodeList.size()];
        nodeList.toArray(nodeArray);
        Arrays.sort(nodeArray);
        int j = 0;
        while (j < nodeArray.length) {
            ((Node)nodeArray[j]).setGraphIndex(j);
            ++j;
        }
        return branches;
    }

    public BranchFigure getBranchFigure(String path) {
        return (BranchFigure)((Object)this.branchMap.get(path));
    }

    public NodeFigure getNodeFigure(Node node) {
        return (NodeFigure)((Object)this.nodeMap.get(node));
    }

    public List getNodes(Branch branch) {
        return (List)this.nodeMap.get(branch);
    }

    private boolean isModified(Branch branch) {
        List nodes = branch.getNodes();
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (!node.getPath().equals(branch.getPath()) || node.getAction() != 'M') continue;
            return true;
        }
        return false;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
    }

    public void setConnectionVisibility() {
        Iterator iter = this.connections.iterator();
        while (iter.hasNext()) {
            PolylineConnection con = (PolylineConnection)iter.next();
            boolean show = false;
            if (!this.store.getBoolean("RevisionGraph_filterConnections")) {
                show = true;
            } else {
                IFigure source = con.getSourceAnchor().getOwner();
                IFigure target = con.getTargetAnchor().getOwner();
                if (source instanceof NodeFigure && ((NodeFigure)source).isSelected()) {
                    show = true;
                } else if (target instanceof NodeFigure && ((NodeFigure)target).isSelected()) {
                    show = true;
                }
            }
            con.setVisible(show);
        }
    }

    public boolean isChronologicalMode() {
        return this.store.getBoolean("RevisionGraph_chronological");
    }

    private PolylineConnection makeConnection(IFigure contents, IFigure source, NodeFigure target) {
        return this.makeConnection(contents, source, target, Activator.CONNECTION_COLOR);
    }

    private PolylineConnection makeConnection(IFigure contents, IFigure source, NodeFigure target, Color color) {
        PolylineConnection c = new PolylineConnection();
        ChopboxAnchor targetAnchor = new ChopboxAnchor((IFigure)target);
        c.setTargetAnchor((ConnectionAnchor)targetAnchor);
        c.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor(source));
        PolygonDecoration decoration = new PolygonDecoration();
        decoration.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        c.setTargetDecoration((RotatableDecoration)decoration);
        c.setForegroundColor(color);
        ConnectionMouseListener listener = new ConnectionMouseListener(c);
        c.addMouseMotionListener((MouseMotionListener)listener);
        c.addMouseListener((MouseListener)listener);
        c.setCursor(Cursors.HAND);
        contents.add((IFigure)c);
        this.connections.add(c);
        return c;
    }

    private void scrollTo(Rectangle fbounds) {
        this.scrollTo(fbounds.x + fbounds.width / 2, fbounds.y + fbounds.height / 2);
    }

    private void scrollTo(int ax, int ay) {
        Viewport viewport = ((FigureCanvas)this.viewer.getControl()).getViewport();
        Rectangle vbounds = viewport.getBounds();
        Point p = new Point(ax, ay);
        int x = p.x - vbounds.width / 2;
        int y = p.y - vbounds.height / 2;
        viewport.setHorizontalLocation(x);
        viewport.setVerticalLocation(y);
    }

    private void scrollTo(IFigure target) {
        this.scrollTo(target.getBounds());
    }

    class ConnectionMouseListener
    implements MouseMotionListener,
    MouseListener {
        private PolylineConnection connection;

        public ConnectionMouseListener(PolylineConnection connection) {
            this.connection = connection;
        }

        public void mouseDragged(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
            this.connection.setLineWidth(1);
        }

        public void mouseHover(MouseEvent event) {
            this.connection.setLineWidth(2);
        }

        public void mouseMoved(MouseEvent event) {
        }

        public void mouseDoubleClicked(MouseEvent event) {
        }

        public void mousePressed(MouseEvent event) {
            NodeFigure nodeFigure = (NodeFigure)this.connection.getTargetAnchor().getOwner();
            GraphEditPart.this.scrollTo((IFigure)nodeFigure);
            Map map = GraphEditPart.this.viewer.getEditPartRegistry();
            EditPart editPart = (EditPart)map.get(nodeFigure.getNode());
            if (editPart != null) {
                GraphEditPart.this.viewer.select(editPart);
            }
        }

        public void mouseReleased(MouseEvent event) {
        }
    }

    class MyXYAnchor
    extends XYAnchor {
        private IFigure f;

        public MyXYAnchor(Point point, IFigure f) {
            super(point);
            this.f = f;
        }

        public Point getLocation(Point reference) {
            Point p = super.getLocation(reference).getCopy();
            this.f.translateToAbsolute((Translatable)p);
            return p;
        }

        public IFigure getOwner() {
            return this.f;
        }
    }
}

