/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.typehierarchy;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.typehierarchy.ClasspathLookup;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyClassReader;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyElement;

public class BytecodeTypeHierarchyClassReader
implements TypeHierarchyClassReader {
    private ClasspathLookup lookup;

    public BytecodeTypeHierarchyClassReader(ClasspathLookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public TypeHierarchyElement readTypeHierarchyInformation(char[] fullyQualifiedClassName, IProject project) {
        String fullyQualifiedClassFileName = String.valueOf(new String(fullyQualifiedClassName)) + ".class";
        String packageName = "";
        String className = fullyQualifiedClassFileName;
        int lastIndexOf = fullyQualifiedClassFileName.lastIndexOf(47);
        if (lastIndexOf > -1) {
            packageName = fullyQualifiedClassFileName.substring(0, lastIndexOf);
            className = fullyQualifiedClassFileName.substring(lastIndexOf + 1);
        }
        InputStream stream = null;
        try {
            stream = this.lookup.getStream(fullyQualifiedClassFileName, packageName, className);
            if (stream != null) {
                TypeHierarchyElement typeHierarchyElement = this.readTypeHierarchy(stream);
                return typeHierarchyElement;
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    SpringCore.log(e);
                }
            }
        }
        return null;
    }

    @Override
    public void cleanup() {
        this.lookup.close();
    }

    public TypeHierarchyElement readTypeHierarchy(InputStream stream) {
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(stream));
            int magic = dis.readInt();
            if (magic != -889275714) {
                throw new IllegalStateException("not bytecode, magic was 0x" + Integer.toString(magic, 16));
            }
            this.skip(dis, 4L);
            int constantPoolCount = dis.readShort();
            Object[] constantPoolData = new Object[constantPoolCount];
            int i = 1;
            while (i < constantPoolCount) {
                byte tag = dis.readByte();
                switch (tag) {
                    case 1: {
                        constantPoolData[i] = dis.readUTF();
                        break;
                    }
                    case 3: {
                        this.skip(dis, 4L);
                        break;
                    }
                    case 4: {
                        this.skip(dis, 4L);
                        break;
                    }
                    case 5: {
                        this.skip(dis, 8L);
                        ++i;
                        break;
                    }
                    case 6: {
                        this.skip(dis, 8L);
                        ++i;
                        break;
                    }
                    case 7: {
                        constantPoolData[i] = dis.readShort();
                        break;
                    }
                    case 8: {
                        this.skip(dis, 2L);
                        break;
                    }
                    case 9: {
                        this.skip(dis, 4L);
                        break;
                    }
                    case 10: {
                        this.skip(dis, 4L);
                        break;
                    }
                    case 11: {
                        this.skip(dis, 4L);
                        break;
                    }
                    case 12: {
                        this.skip(dis, 4L);
                        break;
                    }
                    case 15: {
                        this.skip(dis, 3L);
                        break;
                    }
                    case 16: {
                        this.skip(dis, 2L);
                        break;
                    }
                    case 18: {
                        this.skip(dis, 4L);
                    }
                }
                ++i;
            }
            this.skip(dis, 2L);
            short classNameIndex = dis.readShort();
            short classNameUTF8index = (Short)constantPoolData[classNameIndex];
            char[] className = ((String)constantPoolData[classNameUTF8index]).toCharArray();
            short superclassNameIndex = dis.readShort();
            char[] superclassName = null;
            if (superclassNameIndex != 0) {
                short superclassNameUTF8index = (Short)constantPoolData[superclassNameIndex];
                superclassName = ((String)constantPoolData[superclassNameUTF8index]).toCharArray();
            }
            int interfacesCount = dis.readShort();
            char[][] interfaceNames = null;
            if (interfacesCount != 0) {
                interfaceNames = new char[interfacesCount][];
                int i2 = 0;
                while (i2 < interfacesCount) {
                    short interfaceNameIndex = dis.readShort();
                    short interfaceNameUTF8index = (Short)constantPoolData[interfaceNameIndex];
                    interfaceNames[i2] = ((String)constantPoolData[interfaceNameUTF8index]).toCharArray();
                    ++i2;
                }
            }
            return new TypeHierarchyElement(className, superclassName, interfaceNames);
        }
        catch (Exception e) {
            SpringCore.log(e);
            return null;
        }
    }

    private void skip(InputStream stream, long n) throws IOException {
        long skipped;
        long bytesToSkip = n;
        while ((bytesToSkip -= (skipped = stream.skip(bytesToSkip))) > 0L) {
        }
    }
}

