/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.ide.eclipse.core.io.EclipseFileResourceLoader;
import org.springframework.ide.eclipse.core.io.ExternalFile;
import org.springframework.ide.eclipse.core.io.FileResource;
import org.springframework.ide.eclipse.core.io.StorageResource;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class EclipsePathMatchingResourcePatternResolver
implements ResourcePatternResolver {
    private final PathMatchingResourcePatternResolver patternResolver;
    private final IProject project;
    private final ResourceLoader resourceLoader;
    private final Map<String, Resource[]> resolvedResources = new ConcurrentHashMap<String, Resource[]>();
    private IJavaProject javaProject;
    private IPackageFragmentRoot[] roots;

    public EclipsePathMatchingResourcePatternResolver(IProject project) {
        this(project, JdtUtils.getClassLoader(project, null));
    }

    public EclipsePathMatchingResourcePatternResolver(IProject project, ClassLoader classLoader) {
        this.resourceLoader = new EclipseFileResourceLoader(this, classLoader);
        this.project = project;
        this.patternResolver = new PathMatchingResourcePatternResolver(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.getResourceLoader().getClassLoader();
    }

    public Resource getResource(String location) {
        if (this.resolvedResources.containsKey(location)) {
            return this.resolvedResources.get(location)[0];
        }
        Resource resource = this.patternResolver.getResource(location);
        if (resource != null) {
            try {
                Resource newResource;
                if (this.javaProject == null || this.roots == null) {
                    this.javaProject = JdtUtils.getJavaProject(this.project);
                    this.roots = this.javaProject.getAllPackageFragmentRoots();
                }
                if ((newResource = this.processRawResource(this.roots, resource)) != null) {
                    resource = newResource;
                } else {
                    System.out.println(String.format("!-- could not resolve '%s'", resource));
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (IOException iOException) {}
        }
        this.resolvedResources.put(location, new Resource[]{resource});
        return resource;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        if (this.resolvedResources.containsKey(locationPattern)) {
            return this.resolvedResources.get(locationPattern);
        }
        Resource[] resources = this.patternResolver.getResources(locationPattern);
        HashSet<Resource> foundResources = new HashSet<Resource>();
        try {
            if (this.javaProject == null || this.roots == null) {
                this.javaProject = JdtUtils.getJavaProject(this.project);
                this.roots = this.javaProject.getAllPackageFragmentRoots();
            }
            Resource[] resourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource resource = resourceArray[n2];
                Resource newResource = this.processRawResource(this.roots, resource);
                if (newResource != null) {
                    foundResources.add(newResource);
                } else {
                    System.out.println(String.format("!-- could not resolve '%s'", resource));
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        Resource[] result = foundResources.toArray(new Resource[foundResources.size()]);
        this.resolvedResources.put(locationPattern, result);
        return result;
    }

    private IStorage contains(Object[] resources, String fileName) {
        Object[] objectArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Object resource = objectArray[n2];
            if (resource instanceof IResource ? ((IResource)resource).getName().equals(fileName) : resource instanceof IJarEntryResource && ((IJarEntryResource)resource).getName().equals(fileName)) {
                return (IStorage)resource;
            }
            ++n2;
        }
        return null;
    }

    private Resource processClassResource(String path, String fileName, String typeName, IPackageFragmentRoot root, IJavaElement[] children) throws JavaModelException {
        IJavaElement[] iJavaElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement je = iJavaElementArray[n2];
            if (je instanceof ICompilationUnit) {
                IType[] iTypeArray = ((ICompilationUnit)je).getAllTypes();
                int n3 = iTypeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType type = iTypeArray[n4];
                    if (type.getFullyQualifiedName('$').equals(typeName) && root.getRawClasspathEntry().getEntryKind() == 3) {
                        IResource classResource;
                        IPath outputLocation = root.getRawClasspathEntry().getOutputLocation();
                        if (outputLocation == null) {
                            outputLocation = root.getJavaProject().getOutputLocation();
                        }
                        if ((classResource = ResourcesPlugin.getWorkspace().getRoot().findMember(outputLocation.append(path))) != null) {
                            return new FileResource((IFile)classResource);
                        }
                    }
                    ++n4;
                }
            } else if (je instanceof IClassFile && ((IClassFile)je).getElementName().equals(fileName)) {
                if (root.getResource() != null) {
                    return new StorageResource(new ZipEntryStorage((IFile)root.getResource(), path), this.project);
                }
                File jarFile = root.getPath().toFile();
                return new ExternalFile(jarFile, path, this.project);
            }
            ++n2;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Resource processRawResource(IPackageFragmentRoot[] roots, Resource resource) throws IOException, JavaModelException {
        block24: {
            block25: {
                block23: {
                    if (!(resource instanceof FileSystemResource)) break block23;
                    path = new Path(((FileSystemResource)resource).getPath());
                    projectLocation = this.project.getLocation();
                    if (projectLocation.isPrefixOf((IPath)path) && (file = this.project.getFile(projectRelativePath = path.removeFirstSegments(segmentsToRemove = projectLocation.segmentCount()))) != null && file.exists()) {
                        return new FileResource(file);
                    }
                    fileForLocation = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                    if (fileForLocation != null) {
                        return new FileResource(fileForLocation);
                    }
                    var8_21 = allResourcesFor = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(resource.getURI());
                    if (allResourcesFor.length != 0) {
                        res = var8_21[0];
                        return new FileResource(res);
                    }
                    break block24;
                }
                if (!(resource instanceof UrlResource)) break block25;
                url = resource.getURL();
                path = url.getPath();
                ix = path.indexOf(33);
                if (ix > 0) {
                    entryName = path.substring(ix + 1);
                    path = path.substring(0, ix);
                    try {
                        return new ExternalFile(new File(new URI(path)), entryName, this.project);
                    }
                    catch (URISyntaxException v0) {
                        ** GOTO lbl81
                    }
                } else {
                    var8_22 = allResourcesFor = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(resource.getURI());
                    if (allResourcesFor.length != 0) {
                        res = var8_22[0];
                        return new FileResource(res);
                    }
                }
                break block24;
            }
            if (!(resource instanceof ClassPathResource)) break block24;
            fileName = path = ((ClassPathResource)resource).getPath();
            packageName = "";
            ix = path.lastIndexOf(47);
            if (ix > 0) {
                fileName = path.substring(ix + 1);
                packageName = path.substring(0, ix).replace('/', '.');
            }
            if (fileName.endsWith(".class")) {
                typeName = String.valueOf(packageName) + "." + fileName.substring(0, fileName.length() - 6);
                var11_25 = roots;
                var10_27 = roots.length;
                var9_29 = 0;
                while (var9_29 < var10_27) {
                    root = var11_25[var9_29];
                    storage = null;
                    if ("".equals(packageName) && root.exists()) {
                        storage = this.processClassResource(path, fileName, typeName, root, root.getChildren());
                    }
                    packageFragment = root.getPackageFragment(packageName);
                    if (storage == null && packageFragment != null && packageFragment.exists()) {
                        storage = this.processClassResource(path, fileName, typeName, root, packageFragment.getChildren());
                    }
                    if (storage != null) {
                        return storage;
                    }
                    ++var9_29;
                }
            } else {
                var10_28 = roots;
                var9_30 = roots.length;
                var8_24 = 0;
                while (var8_24 < var9_30) {
                    root = var10_28[var8_24];
                    storage = null;
                    if ("".equals(packageName) && root.exists()) {
                        storage = this.contains(root.getNonJavaResources(), fileName);
                    }
                    packageFragment = root.getPackageFragment(packageName);
                    if (storage == null && packageFragment != null && packageFragment.exists()) {
                        storage = this.contains(packageFragment.getNonJavaResources(), fileName);
                    }
                    if (storage == null && (rootResource = root.getUnderlyingResource()) instanceof IFolder && (file = ((IFolder)rootResource).getFile(path)).exists()) {
                        storage = file;
                    }
                    if (storage != null) {
                        if (storage instanceof IFile) {
                            return new FileResource((IFile)storage);
                        }
                        if (storage instanceof IJarEntryResource) {
                            if (root.getResource() != null) {
                                return new StorageResource(new ZipEntryStorage((IFile)root.getResource(), ((IJarEntryResource)storage).getFullPath().toString()), this.project);
                            }
                            jarFile = root.getPath().toFile();
                            return new ExternalFile(jarFile, ((IJarEntryResource)storage).getFullPath().toString(), this.project);
                        }
                    }
                    ++var8_24;
                }
            }
        }
        return null;
    }
}

