/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.generatediff;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.wizards.generatediff.GenerateDiffFileOperation;
import org.tigris.subversion.subclipse.ui.wizards.generatediff.OptionsPage;
import org.tigris.subversion.subclipse.ui.wizards.generatediff.PatchFileSelectionPage;

public class GenerateDiffFileWizard
extends Wizard {
    private PatchFileSelectionPage mainPage;
    private IStructuredSelection selection;
    private IResource[] unaddedResources;
    private HashMap statusMap;
    private IResource[] selectedResources;
    private OptionsPage optionsPage;

    public GenerateDiffFileWizard(IStructuredSelection selection, IResource[] unaddedResources, HashMap statusMap) {
        this.selection = selection;
        this.unaddedResources = unaddedResources;
        this.statusMap = statusMap;
        this.setWindowTitle(Policy.bind("GenerateSVNDiff.title"));
        this.initializeDefaultPageImageDescriptor();
    }

    public void addPages() {
        String pageTitle = Policy.bind("GenerateSVNDiff.pageTitle");
        String pageDescription = Policy.bind("GenerateSVNDiff.pageDescription");
        this.mainPage = new PatchFileSelectionPage(pageTitle, pageTitle, SVNUIPlugin.getPlugin().getImageDescriptor("wizban/createpatch_wizban.gif"), this.selection, this.statusMap);
        this.mainPage.setDescription(pageDescription);
        pageTitle = Policy.bind("GenerateSVNDiff.AdvancedOptions");
        pageDescription = Policy.bind("GenerateSVNDiff.ConfigureOptions");
        this.optionsPage = new OptionsPage(pageTitle, pageTitle, SVNUIPlugin.getPlugin().getImageDescriptor("wizban/createpatch_wizban.gif"));
        this.optionsPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.optionsPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected void initializeDefaultPageImageDescriptor() {
        String iconPath = "icons/full/";
        try {
            URL installURL = SVNUIPlugin.getPlugin().getBundle().getEntry("/");
            URL url = new URL(installURL, String.valueOf(iconPath) + "wizards/newconnect_wiz.gif");
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.setDefaultPageImageDescriptor(desc);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        String fs = this.mainPage.getFilesystemFile();
        IFile ws = this.mainPage.getWorkspaceFile();
        int type = this.mainPage.getSaveType();
        boolean eclipseFormat = this.optionsPage.isMultiPatch();
        boolean projectRelative = this.optionsPage.isProjectRelative();
        try {
            if (type == this.mainPage.CLIPBOARD) {
                GenerateDiffFileOperation generateDiffFileOperation = new GenerateDiffFileOperation(this.getResources(), this.getUnaddedResources(), null, true, false, eclipseFormat, projectRelative, this.getShell());
                generateDiffFileOperation.setSelectedResources(this.selectedResources);
                this.getContainer().run(true, true, (IRunnableWithProgress)generateDiffFileOperation);
                return true;
            }
            File file = new File(fs != null ? fs : ws.getLocation().toOSString());
            if (file.exists()) {
                String title = Policy.bind("GenerateSVNDiff.overwriteTitle");
                String msg = Policy.bind("GenerateSVNDiff.overwriteMsg");
                MessageDialog dialog = new MessageDialog(this.getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                dialog.open();
                if (dialog.getReturnCode() != 0) {
                    return false;
                }
            }
            GenerateDiffFileOperation generateDiffFileOperation = new GenerateDiffFileOperation(this.getResources(), this.getUnaddedResources(), file, false, false, eclipseFormat, projectRelative, this.getShell());
            generateDiffFileOperation.setSelectedResources(this.selectedResources);
            this.getContainer().run(true, true, (IRunnableWithProgress)generateDiffFileOperation);
            if (type != this.mainPage.WORKSPACE) return true;
            ws.getParent().refreshLocal(1, null);
            return true;
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        catch (CoreException e) {
            SVNUIPlugin.openError(this.getShell(), Policy.bind("GenerateSVNDiff.error"), null, e);
            return false;
        }
        catch (InvocationTargetException e2) {
            SVNUIPlugin.openError(this.getShell(), Policy.bind("GenerateSVNDiff.error"), null, e2);
            return false;
        }
    }

    protected IResource[] getResources() {
        return this.mainPage.getSelectedResources();
    }

    private IResource[] getUnaddedResources() {
        ArrayList<IResource> unaddedResourceList = new ArrayList<IResource>();
        int i = 0;
        while (i < this.unaddedResources.length) {
            unaddedResourceList.add(this.unaddedResources[i]);
            ++i;
        }
        ArrayList<IResource> selectedUnaddedResourceList = new ArrayList<IResource>();
        IResource[] selectedResources = this.getResources();
        int i2 = 0;
        while (i2 < selectedResources.length) {
            if (unaddedResourceList.contains(selectedResources[i2])) {
                selectedUnaddedResourceList.add(selectedResources[i2]);
            } else {
                IResource unaddedParent = this.getUnaddedParent(selectedResources[i2], unaddedResourceList);
                if (unaddedParent != null && !selectedUnaddedResourceList.contains(unaddedParent)) {
                    selectedUnaddedResourceList.add(unaddedParent);
                }
            }
            ++i2;
        }
        IResource[] unaddedResourceArray = new IResource[selectedUnaddedResourceList.size()];
        selectedUnaddedResourceList.toArray(unaddedResourceArray);
        return unaddedResourceArray;
    }

    private IResource getUnaddedParent(IResource resource, ArrayList unaddedResourceList) {
        IResource parent = resource;
        while (parent != null) {
            int index = unaddedResourceList.indexOf(parent = parent.getParent());
            if (index == -1) continue;
            return (IResource)unaddedResourceList.get(index);
        }
        return null;
    }

    public void setSelectedResources(IResource[] selectedResources) {
        this.selectedResources = selectedResources;
    }
}

