/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.SVNPluginAction;
import org.tigris.subversion.subclipse.ui.comments.CommitCommentArea;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalCompareInput;
import org.tigris.subversion.subclipse.ui.dialogs.ResourceWithStatusUtil;
import org.tigris.subversion.subclipse.ui.settings.CommentProperties;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.subclipse.ui.util.LinkList;
import org.tigris.subversion.subclipse.ui.util.ResourceSelectionTree;
import org.tigris.subversion.subclipse.ui.wizards.IClosableWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialogPage;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SvnWizardCommitPage
extends SvnWizardDialogPage {
    public static final String COMMIT_WIZARD_DIALOG_SETTINGS = "CommitWizard";
    public static final String SHOW_COMPARE = "ShowCompare";
    private static final String H_WEIGHT_1 = "HWeight1";
    private static final String H_WEIGHT_2 = "HWeight2";
    private static final String V_WEIGHT_1 = "VWeight1";
    private static final String V_WEIGHT_2 = "VWeight2";
    private SashForm verticalSash;
    private SashForm horizontalSash;
    private boolean showCompare;
    private CommitCommentArea commitCommentArea;
    private IResource[] resourcesToCommit;
    private ProjectProperties projectProperties;
    private Object[] selectedResources;
    private Text issueText;
    private String issue;
    private Button keepLocksButton;
    private Button includeUnversionedButton;
    private Button showCompareButton;
    private boolean keepLocks;
    private boolean includeUnversioned;
    private IDialogSettings settings;
    private CommentProperties commentProperties;
    private SyncInfoSet syncInfoSet;
    private String removalError;
    private boolean fromSyncView;
    private Action includeUnversionedAction;
    private Action keepLocksAction;
    private HashMap statusMap;
    private ResourceSelectionTree resourceSelectionTree;
    private CompareViewerSwitchingPane compareViewerPane;

    public SvnWizardCommitPage(IResource[] resourcesToCommit, String url, ProjectProperties projectProperties, HashMap statusMap, ChangeSet changeSet, boolean fromSyncView) {
        super("CommitDialog", null);
        this.fromSyncView = fromSyncView;
        this.includeUnversioned = fromSyncView ? true : SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_select_unadded_resources_on_commit");
        this.resourcesToCommit = resourcesToCommit;
        this.projectProperties = projectProperties;
        this.statusMap = statusMap;
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
        if (changeSet == null) {
            if (url == null) {
                this.setTitle(String.valueOf(Policy.bind("CommitDialog.commitTo")) + " " + Policy.bind("CommitDialog.multiple"));
            } else {
                this.setTitle(String.valueOf(Policy.bind("CommitDialog.commitTo")) + " " + url);
            }
        } else {
            this.setTitle(String.valueOf(Policy.bind("CommitDialog.commitToChangeSet")) + " " + changeSet.getName());
        }
        if (resourcesToCommit.length > 0) {
            try {
                this.commentProperties = CommentProperties.getCommentProperties(resourcesToCommit[0]);
            }
            catch (SVNException sVNException) {}
        }
        this.commitCommentArea = new CommitCommentArea(null, null, this.commentProperties);
        this.commitCommentArea.setShowLabel(false);
        if (this.commentProperties != null && this.commentProperties.getMinimumLogMessageSize() != 0) {
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SvnWizardCommitPage.this.setPageComplete(SvnWizardCommitPage.this.canFinish());
                }
            };
            this.commitCommentArea.setModifyListener(modifyListener);
        }
    }

    public void createControls(Composite composite) {
        this.horizontalSash = new SashForm(composite, 256);
        this.horizontalSash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.verticalSash = new SashForm((Composite)this.horizontalSash, 512);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.verticalSash.setLayout((Layout)gridLayout);
        this.verticalSash.setLayoutData((Object)new GridData(1808));
        Composite cTop = new Composite((Composite)this.verticalSash, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        cTop.setLayout((Layout)topLayout);
        cTop.setLayoutData((Object)new GridData(1808));
        Composite cBottom1 = new Composite((Composite)this.verticalSash, 0);
        GridLayout bottom1Layout = new GridLayout();
        bottom1Layout.marginHeight = 0;
        bottom1Layout.marginWidth = 0;
        cBottom1.setLayout((Layout)bottom1Layout);
        cBottom1.setLayoutData((Object)new GridData(1808));
        Composite cBottom2 = new Composite(cBottom1, 0);
        GridLayout bottom2Layout = new GridLayout();
        bottom2Layout.marginHeight = 0;
        bottom2Layout.marginWidth = 0;
        cBottom2.setLayout((Layout)bottom2Layout);
        cBottom2.setLayoutData((Object)new GridData(1808));
        try {
            int[] weights = new int[]{this.settings.getInt("CommitDialog.weights.0"), this.settings.getInt("CommitDialog.weights.1")};
            this.verticalSash.setWeights(weights);
        }
        catch (Exception exception) {
            this.verticalSash.setWeights(new int[]{5, 4});
        }
        this.verticalSash.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                int[] weights = SvnWizardCommitPage.this.verticalSash.getWeights();
                int i = 0;
                while (i < weights.length) {
                    SvnWizardCommitPage.this.settings.put("CommitDialog.weights." + i, weights[i]);
                    ++i;
                }
            }
        });
        if (this.projectProperties != null && this.projectProperties.getMessage() != null) {
            this.addBugtrackingArea(cTop);
        }
        this.commitCommentArea.createArea(cTop);
        this.commitCommentArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "OkRequested" && SvnWizardCommitPage.this.canFinish()) {
                    IClosableWizard wizard = (IClosableWizard)SvnWizardCommitPage.this.getWizard();
                    wizard.finishAndClose();
                }
            }
        });
        this.addResourcesArea(cBottom2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.commit_dialog_context");
        this.setPageComplete(this.canFinish());
        this.compareViewerPane = new CompareViewerSwitchingPane((Composite)this.horizontalSash, 0x800800){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                CompareConfiguration cc = new CompareConfiguration();
                cc.setLeftEditable(false);
                cc.setRightEditable(false);
                return CompareUI.findContentViewer((Viewer)oldViewer, (Object)input, (Composite)this, (CompareConfiguration)cc);
            }
        };
        this.compareViewerPane.setLayoutData((Object)new GridData(4, 4, true, true));
        IDialogSettings section = this.settings.getSection(COMMIT_WIZARD_DIALOG_SETTINGS);
        this.showCompare = section == null ? false : section.getBoolean(SHOW_COMPARE);
        int vWeight1 = 50;
        int vWeight2 = 50;
        if (section != null) {
            try {
                vWeight1 = section.getInt(V_WEIGHT_1);
                vWeight2 = section.getInt(V_WEIGHT_2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int hWeight1 = 35;
        int hWeight2 = 65;
        if (section != null) {
            try {
                hWeight1 = section.getInt(H_WEIGHT_1);
                hWeight2 = section.getInt(H_WEIGHT_2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!this.showCompare) {
            this.horizontalSash.setMaximizedControl((Control)this.verticalSash);
        } else {
            this.showCompareButton.setSelection(true);
        }
        this.verticalSash.setWeights(new int[]{vWeight1, vWeight2});
        this.horizontalSash.setWeights(new int[]{hWeight1, hWeight2});
    }

    public void updatePreference(boolean includeUnversioned) {
        SVNUIPlugin.getPlugin().getPreferenceStore().setValue("pref_select_unadded_resources_on_commit", includeUnversioned);
    }

    private void addResourcesArea(Composite composite) {
        final SVNPluginAction[] toolbarActions = SVNUIPlugin.getCommitDialogToolBarActions();
        final SVNPluginAction[] alternateCompareActions = SVNUIPlugin.getCommitDialogCompareActions();
        ResourceSelectionTree.IToolbarControlCreator toolbarControlCreator = new ResourceSelectionTree.IToolbarControlCreator(){

            public void createToolbarControls(ToolBarManager toolbarManager) {
                toolbarManager.add((IContributionItem)new ControlContribution("ignoreUnversioned"){

                    protected Control createControl(Composite parent) {
                        SvnWizardCommitPage.this.includeUnversionedButton = new Button(parent, 32);
                        SvnWizardCommitPage.this.includeUnversionedButton.setText(Policy.bind("CommitDialog.includeUnversioned"));
                        SvnWizardCommitPage.this.includeUnversionedButton.setSelection(SvnWizardCommitPage.this.includeUnversioned);
                        SvnWizardCommitPage.this.includeUnversionedButton.addSelectionListener(new SelectionListener(this){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void widgetSelected(SelectionEvent e) {
                                SvnWizardCommitPage.access$6(5.access$0(1.access$0(this.this$2)), SvnWizardCommitPage.access$4(5.access$0(1.access$0(this.this$2))).getSelection());
                                SvnWizardCommitPage.access$7(5.access$0(1.access$0(this.this$2))).setChecked(SvnWizardCommitPage.access$5(5.access$0(1.access$0(this.this$2))));
                                SvnWizardCommitPage.access$8(5.access$0(1.access$0(this.this$2)));
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }
                        });
                        return SvnWizardCommitPage.this.includeUnversionedButton;
                    }

                    static /* synthetic */ 5 access$0(1 var0) {
                        return var0.this;
                    }
                });
                toolbarManager.add((IContributionItem)new ControlContribution("keepLocks"){

                    protected Control createControl(Composite parent) {
                        SvnWizardCommitPage.this.keepLocksButton = new Button(parent, 32);
                        SvnWizardCommitPage.this.keepLocksButton.setText(Policy.bind("CommitDialog.keepLocks"));
                        SvnWizardCommitPage.this.keepLocksButton.addSelectionListener(new SelectionListener(this){
                            final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void widgetSelected(SelectionEvent e) {
                                SvnWizardCommitPage.access$11(5.access$0(2.access$0(this.this$2)), SvnWizardCommitPage.access$10(5.access$0(2.access$0(this.this$2))).getSelection());
                                SvnWizardCommitPage.access$12(5.access$0(2.access$0(this.this$2))).setChecked(SvnWizardCommitPage.access$10(5.access$0(2.access$0(this.this$2))).getSelection());
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }
                        });
                        return SvnWizardCommitPage.this.keepLocksButton;
                    }

                    static /* synthetic */ 5 access$0(2 var0) {
                        return var0.this;
                    }
                });
                toolbarManager.add((IContributionItem)new Separator());
                toolbarManager.add((IContributionItem)new ControlContribution("showCompare"){

                    protected Control createControl(Composite parent) {
                        SvnWizardCommitPage.this.showCompareButton = new Button(parent, 0x800002);
                        SvnWizardCommitPage.this.showCompareButton.setImage(SVNUIPlugin.getImage("elcl16/syncpane_co.gif"));
                        SvnWizardCommitPage.this.showCompareButton.setToolTipText(Policy.bind("CommitDialog.showCompare"));
                        SvnWizardCommitPage.this.showCompareButton.setSelection(SvnWizardCommitPage.this.showCompare);
                        SvnWizardCommitPage.this.showCompareButton.addSelectionListener(new SelectionListener(this, alternateCompareActions){
                            final /* synthetic */ 3 this$2;
                            private final /* synthetic */ SVNPluginAction[] val$alternateCompareActions;
                            {
                                this.this$2 = var1_1;
                                this.val$alternateCompareActions = sVNPluginActionArray;
                            }

                            public void widgetSelected(SelectionEvent e) {
                                Object sel0;
                                IStructuredSelection selection;
                                5.access$0(3.access$0(this.this$2)).showComparePane(!SvnWizardCommitPage.access$15(5.access$0(3.access$0(this.this$2))));
                                if (SvnWizardCommitPage.access$15(5.access$0(3.access$0(this.this$2))) && !(selection = (IStructuredSelection)SvnWizardCommitPage.access$16(5.access$0(3.access$0(this.this$2))).getTreeViewer().getSelection()).isEmpty() && (sel0 = selection.getFirstElement()) instanceof IFile) {
                                    ISVNLocalResource localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)((IFile)sel0));
                                    try {
                                        if (this.val$alternateCompareActions.length > 0) {
                                            StructuredSelection localResourceSelection = new StructuredSelection((Object)localResource);
                                            int i = 0;
                                            while (i < this.val$alternateCompareActions.length) {
                                                this.val$alternateCompareActions[i].selectionChanged((ISelection)localResourceSelection);
                                                this.val$alternateCompareActions[i].run();
                                                ++i;
                                            }
                                        } else {
                                            SvnWizardCommitPage.access$17(5.access$0(3.access$0(this.this$2)), new SVNLocalCompareInput(localResource, SVNRevision.BASE, true));
                                        }
                                    }
                                    catch (Exception exception) {}
                                }
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }
                        });
                        return SvnWizardCommitPage.this.showCompareButton;
                    }

                    static /* synthetic */ 5 access$0(3 var0) {
                        return var0.this;
                    }
                });
                if (toolbarActions.length > 0) {
                    toolbarManager.add((IContributionItem)new Separator());
                    int i = 0;
                    while (i < toolbarActions.length) {
                        SVNPluginAction action = toolbarActions[i];
                        toolbarManager.add((IAction)action);
                        ++i;
                    }
                }
            }

            public int getControlCount() {
                return 1;
            }
        };
        this.resourceSelectionTree = new ResourceSelectionTree(composite, 0, Policy.bind("GenerateSVNDiff.Changes"), ResourceSelectionTree.dedupeResources(this.resourcesToCommit), this.statusMap, null, true, toolbarControlCreator, this.syncInfoSet);
        if (!this.resourceSelectionTree.showIncludeUnversionedButton()) {
            this.includeUnversionedButton.setVisible(false);
        }
        this.resourceSelectionTree.setCustomOptions(this.getCustomOptions());
        this.resourceSelectionTree.setRemoveFromViewValidator(new ResourceSelectionTree.IRemoveFromViewValidator(){

            public boolean canRemove(ArrayList resourceList, IStructuredSelection selection) {
                return SvnWizardCommitPage.this.removalOk(resourceList, selection);
            }

            public String getErrorMessage() {
                return SvnWizardCommitPage.this.removalError;
            }
        });
        this.resourceSelectionTree.getTreeViewer().getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object sel0;
                SvnWizardCommitPage.this.selectedResources = SvnWizardCommitPage.this.resourceSelectionTree.getSelectedResources();
                IStructuredSelection selection = (IStructuredSelection)SvnWizardCommitPage.this.resourceSelectionTree.getTreeViewer().getSelection();
                if (toolbarActions.length > 0) {
                    int i = 0;
                    while (i < toolbarActions.length) {
                        SVNPluginAction action = toolbarActions[i];
                        action.selectionChanged((ISelection)selection);
                        ++i;
                    }
                }
                if (SvnWizardCommitPage.this.showCompare && (sel0 = selection.getFirstElement()) instanceof IFile) {
                    ISVNLocalResource localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)((IFile)sel0));
                    try {
                        if (alternateCompareActions.length > 0) {
                            StructuredSelection localResourceSelection = new StructuredSelection((Object)localResource);
                            int i = 0;
                            while (i < alternateCompareActions.length) {
                                alternateCompareActions[i].selectionChanged((ISelection)localResourceSelection);
                                alternateCompareActions[i].run();
                                ++i;
                            }
                        } else {
                            SvnWizardCommitPage.this.setCompareInput(new SVNLocalCompareInput(localResource, SVNRevision.BASE, true));
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
        ((CheckboxTreeViewer)this.resourceSelectionTree.getTreeViewer()).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SvnWizardCommitPage.this.selectedResources = SvnWizardCommitPage.this.resourceSelectionTree.getSelectedResources();
            }
        });
        this.resourceSelectionTree.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object sel0 = sel.getFirstElement();
                if (sel0 instanceof IFile) {
                    ISVNLocalResource localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)((IFile)sel0));
                    try {
                        if (alternateCompareActions.length > 0) {
                            StructuredSelection selection = new StructuredSelection((Object)localResource);
                            int i = 0;
                            while (i < alternateCompareActions.length) {
                                alternateCompareActions[i].selectionChanged((ISelection)selection);
                                alternateCompareActions[i].run();
                                ++i;
                            }
                        } else {
                            SvnWizardCommitPage.this.setCompareInput(new SVNLocalCompareInput(localResource, SVNRevision.BASE, true));
                            SvnWizardCommitPage.this.showComparePane(true);
                            SvnWizardCommitPage.this.showCompareButton.setSelection(true);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
        if (!this.includeUnversioned) {
            this.resourceSelectionTree.removeUnversioned();
        }
        this.selectedResources = this.resourceSelectionTree.getSelectedResources();
        this.setPageComplete(this.canFinish());
    }

    private void toggleIncludeUnversioned() {
        if (!this.includeUnversioned) {
            this.resourceSelectionTree.removeUnversioned();
        } else {
            this.resourceSelectionTree.addUnversioned();
        }
        this.selectedResources = this.resourceSelectionTree.getSelectedResources();
        this.setPageComplete(this.canFinish());
        if (!this.fromSyncView) {
            this.updatePreference(this.includeUnversioned);
        }
    }

    private Action[] getCustomOptions() {
        ArrayList<Action> customOptions = new ArrayList<Action>();
        if (this.resourceSelectionTree.showIncludeUnversionedButton()) {
            this.includeUnversionedAction = new Action(Policy.bind("CommitDialog.includeUnversioned"), 2){

                public void run() {
                    SvnWizardCommitPage.this.includeUnversioned = !SvnWizardCommitPage.this.includeUnversioned;
                    if (SvnWizardCommitPage.this.includeUnversionedButton.isVisible()) {
                        SvnWizardCommitPage.this.includeUnversionedButton.setSelection(SvnWizardCommitPage.this.includeUnversioned);
                    }
                    SvnWizardCommitPage.this.toggleIncludeUnversioned();
                }
            };
            this.includeUnversionedAction.setChecked(this.includeUnversioned);
            customOptions.add(this.includeUnversionedAction);
        }
        this.keepLocksAction = new Action(Policy.bind("CommitDialog.keepLocks"), 2){

            public void run() {
                SvnWizardCommitPage.this.keepLocks = !SvnWizardCommitPage.this.keepLocks;
                if (SvnWizardCommitPage.this.keepLocksButton.isVisible()) {
                    SvnWizardCommitPage.this.keepLocksButton.setSelection(SvnWizardCommitPage.this.keepLocks);
                }
            }
        };
        customOptions.add(this.keepLocksAction);
        Action[] customOptionArray = new Action[customOptions.size()];
        customOptions.toArray(customOptionArray);
        return customOptionArray;
    }

    private void addBugtrackingArea(Composite composite) {
        Composite bugtrackingComposite = new Composite(composite, 0);
        GridLayout bugtrackingLayout = new GridLayout();
        bugtrackingLayout.numColumns = 2;
        bugtrackingComposite.setLayout((Layout)bugtrackingLayout);
        Label label = new Label(bugtrackingComposite, 0);
        label.setText(this.projectProperties.getLabel());
        this.issueText = new Text(bugtrackingComposite, 2048);
        GridData data = new GridData();
        data.widthHint = 150;
        this.issueText.setLayoutData((Object)data);
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        if (!this.confirmUserData()) {
            return false;
        }
        this.selectedResources = this.resourceSelectionTree.getSelectedResources();
        int[] hWeights = this.horizontalSash.getWeights();
        int[] vWeights = this.verticalSash.getWeights();
        IDialogSettings section = this.settings.getSection(COMMIT_WIZARD_DIALOG_SETTINGS);
        if (section == null) {
            section = this.settings.addNewSection(COMMIT_WIZARD_DIALOG_SETTINGS);
        }
        if (this.showCompare) {
            section.put(H_WEIGHT_1, hWeights[0]);
            section.put(H_WEIGHT_2, hWeights[1]);
        }
        section.put(V_WEIGHT_1, vWeights[0]);
        section.put(V_WEIGHT_2, vWeights[1]);
        section.put(SHOW_COMPARE, this.showCompare);
        return true;
    }

    private boolean confirmUserData() {
        if (this.projectProperties != null) {
            int issueCount = 0;
            if (this.projectProperties.getMessage() != null) {
                this.issue = this.issueText.getText().trim();
                if (this.issue.length() > 0) {
                    String issueError = this.projectProperties.validateIssue(this.issue);
                    if (issueError != null) {
                        MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("CommitDialog.title"), (String)issueError);
                        this.issueText.selectAll();
                        this.issueText.setFocus();
                        return false;
                    }
                    ++issueCount;
                }
            }
            if (this.projectProperties.getLogregex() != null) {
                try {
                    LinkList linkList = this.projectProperties.getLinkList(this.commitCommentArea.getComment());
                    String[] urls = linkList.getUrls();
                    issueCount += urls.length;
                }
                catch (Exception e) {
                    this.handle(e, null, null);
                }
            }
            if (this.projectProperties.isWarnIfNoIssue() && issueCount == 0) {
                if (this.projectProperties.getMessage() != null && this.projectProperties.getLogregex() == null) {
                    if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("CommitDialog.title"), (String)Policy.bind("CommitDialog.0", this.projectProperties.getLabel()))) {
                        this.issueText.setFocus();
                        return false;
                    }
                } else if (this.projectProperties.getMessage() == null && this.projectProperties.getLogregex() != null) {
                    if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("CommitDialog.title"), (String)Policy.bind("CommitDialog.1", this.projectProperties.getLabel()))) {
                        this.commitCommentArea.setFocus();
                        return false;
                    }
                } else if (this.projectProperties.getMessage() != null && this.projectProperties.getLogregex() != null && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("CommitDialog.title"), (String)Policy.bind("CommitDialog.2", this.projectProperties.getLabel()))) {
                    this.commitCommentArea.setFocus();
                    return false;
                }
            }
        }
        return true;
    }

    private void setCompareInput(SVNLocalCompareInput input) {
        try {
            input.run(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.compareViewerPane.setInput(input.getCompareResult());
    }

    public void showComparePane(boolean showCompare) {
        this.showCompare = showCompare;
        if (showCompare) {
            this.horizontalSash.setMaximizedControl(null);
        } else {
            this.horizontalSash.setMaximizedControl((Control)this.verticalSash);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean removalOk(ArrayList resourceList, IStructuredSelection selection) {
        ArrayList clonedList = (ArrayList)resourceList.clone();
        ArrayList<IResource> deletedFolders = new ArrayList<IResource>();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            clonedList.remove(iter.next());
        }
        ArrayList<IResource> folderPropertyChanges = new ArrayList<IResource>();
        boolean folderDeletionSelected = false;
        for (IResource resource : clonedList) {
            String string;
            if (!(resource instanceof IContainer)) continue;
            if (ResourceWithStatusUtil.getStatus(resource).equals(Policy.bind("CommitDialog.deleted"))) {
                folderDeletionSelected = true;
                deletedFolders.add(resource);
            }
            if ((string = ResourceWithStatusUtil.getPropertyStatus(resource)) == null || string.length() <= 0) continue;
            folderPropertyChanges.add(resource);
        }
        if (folderDeletionSelected) {
            for (IResource resource : selection) {
                for (IContainer iContainer : deletedFolders) {
                    if (!this.isChild(resource, iContainer)) continue;
                    this.removalError = Policy.bind("CommitDialog.parentDeleted");
                    return false;
                }
            }
        }
        if (!folderDeletionSelected || folderPropertyChanges.size() == 0) {
            return true;
        }
        boolean unselectedPropChangeChildren = false;
        block4: for (IContainer iContainer : folderPropertyChanges) {
            void var10_17;
            boolean bl = false;
            while (var10_17 < this.resourcesToCommit.length) {
                if (!clonedList.contains(this.resourcesToCommit[var10_17]) && this.isChild(this.resourcesToCommit[var10_17], iContainer)) {
                    unselectedPropChangeChildren = true;
                    this.removalError = Policy.bind("CommitDialog.unselectedPropChangeChildren");
                    break block4;
                }
                ++var10_17;
            }
        }
        return !unselectedPropChangeChildren;
    }

    private boolean isChild(IResource resource, IContainer folder) {
        IContainer container = resource.getParent();
        while (container != null) {
            if (container.getFullPath().toString().equals(folder.getFullPath().toString())) {
                return true;
            }
            container = container.getParent();
        }
        return false;
    }

    public void setMessage() {
        this.setMessage(Policy.bind("CommitDialog.message"));
    }

    private boolean canFinish() {
        this.selectedResources = this.resourceSelectionTree.getSelectedResources();
        if (this.selectedResources.length == 0) {
            return false;
        }
        if (this.commentProperties == null) {
            return true;
        }
        return this.commitCommentArea.getCommentLength() >= this.commentProperties.getMinimumLogMessageSize();
    }

    public String getComment() {
        String comment = null;
        comment = this.projectProperties != null && this.issue != null && this.issue.length() > 0 ? (this.projectProperties.isAppend() ? String.valueOf(this.commitCommentArea.getComment()) + "\n" + this.projectProperties.getResolvedMessage(this.issue) + "\n" : String.valueOf(this.projectProperties.getResolvedMessage(this.issue)) + "\n" + this.commitCommentArea.getComment()) : this.commitCommentArea.getComment();
        this.commitCommentArea.addComment(this.commitCommentArea.getComment());
        return comment;
    }

    public IResource[] getSelectedResources() {
        if (this.selectedResources == null) {
            return this.resourcesToCommit;
        }
        List<Object> result = Arrays.asList(this.selectedResources);
        return result.toArray(new IResource[result.size()]);
    }

    public boolean isKeepLocks() {
        return this.keepLocks;
    }

    public void setComment(String proposedComment) {
        this.commitCommentArea.setProposedComment(proposedComment);
    }

    public void saveSettings() {
    }

    public String getWindowTitle() {
        return Policy.bind("CommitDialog.title");
    }

    public void setSyncInfoSet(SyncInfoSet syncInfoSet) {
        this.syncInfoSet = syncInfoSet;
    }

    public void createButtonsForButtonBar(Composite parent, SvnWizardDialog wizardDialog) {
    }

    protected void handle(Exception exception, String title, String message) {
        SVNUIPlugin.openError(this.getShell(), title, message, exception, 12);
    }

    static /* synthetic */ Action access$7(SvnWizardCommitPage svnWizardCommitPage) {
        return svnWizardCommitPage.includeUnversionedAction;
    }

    static /* synthetic */ Action access$12(SvnWizardCommitPage svnWizardCommitPage) {
        return svnWizardCommitPage.keepLocksAction;
    }
}

