/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.wizards.CheckoutWizard;

public class CheckoutWizardProjectPage
extends WizardPage {
    private Button defaultButton;
    private Label locationLabel;
    private Text locationText;
    private Button browseButton;
    private Button addToWorkingSetsButton;
    private Label workingSetsLabel;
    private Combo workingSetsCombo;
    private Button workingSetsSelectButton;
    private IWorkingSet[] workingSets;
    private Map<String, IWorkingSet[]> workingSetsMap = new HashMap<String, IWorkingSet[]>();

    public CheckoutWizardProjectPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(768));
        this.defaultButton = new Button(outerContainer, 32);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.defaultButton.setLayoutData((Object)data);
        this.defaultButton.setText(Policy.bind("CheckoutWizardProjectPage.default"));
        this.defaultButton.setSelection(true);
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWizardProjectPage.this.setLocationEnablement();
                if (!CheckoutWizardProjectPage.this.defaultButton.getSelection()) {
                    CheckoutWizardProjectPage.this.locationText.selectAll();
                    CheckoutWizardProjectPage.this.locationText.setFocus();
                }
                CheckoutWizardProjectPage.this.setPageComplete();
            }
        });
        this.locationLabel = new Label(outerContainer, 0);
        this.locationLabel.setText(Policy.bind("CheckoutWizardProjectPage.location"));
        this.locationText = new Text(outerContainer, 2048);
        data = new GridData(768);
        this.locationText.setLayoutData((Object)data);
        this.setLocation();
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CheckoutWizardProjectPage.this.setPageComplete();
            }
        });
        this.browseButton = new Button(outerContainer, 8);
        this.browseButton.setText(Policy.bind("CheckoutWizardProjectPage.browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(CheckoutWizardProjectPage.this.getShell());
                dialog.setMessage(Policy.bind("CheckoutInto.message"));
                String directory = dialog.open();
                if (directory != null) {
                    CheckoutWizardProjectPage.this.locationText.setText(directory);
                }
            }
        });
        this.setLocationEnablement();
        Composite workingSetsComposite = new Composite(outerContainer, 0);
        GridLayout workingSetsLayout = new GridLayout();
        workingSetsLayout.numColumns = 3;
        workingSetsLayout.marginHeight = 0;
        workingSetsLayout.marginWidth = 0;
        workingSetsComposite.setLayout((Layout)workingSetsLayout);
        data = new GridData(768);
        data.horizontalSpan = 3;
        workingSetsComposite.setLayoutData((Object)data);
        this.addToWorkingSetsButton = new Button(workingSetsComposite, 32);
        this.addToWorkingSetsButton.setText(Policy.bind("CheckoutWizardProjectPage.0"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.addToWorkingSetsButton.setLayoutData((Object)data);
        this.addToWorkingSetsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWizardProjectPage.this.setWorkingSetsEnablement();
            }
        });
        this.workingSetsLabel = new Label(workingSetsComposite, 0);
        this.workingSetsLabel.setText(Policy.bind("CheckoutWizardProjectPage.1"));
        this.workingSetsCombo = new Combo(workingSetsComposite, 2056);
        this.workingSetsCombo.setLayoutData((Object)new GridData(768));
        this.workingSetsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWizardProjectPage.this.workingSets = (IWorkingSet[])CheckoutWizardProjectPage.this.workingSetsMap.get(CheckoutWizardProjectPage.this.workingSetsCombo.getText());
            }
        });
        this.workingSetsSelectButton = new Button(workingSetsComposite, 8);
        this.workingSetsSelectButton.setText(Policy.bind("CheckoutWizardProjectPage.2"));
        this.workingSetsSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
                IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(CheckoutWizardProjectPage.this.getShell(), true);
                if (CheckoutWizardProjectPage.this.workingSets != null) {
                    dialog.setSelection(CheckoutWizardProjectPage.this.workingSets);
                }
                dialog.open();
                CheckoutWizardProjectPage.this.workingSets = dialog.getSelection();
                if (CheckoutWizardProjectPage.this.workingSets != null) {
                    String workingSetsString = CheckoutWizardProjectPage.this.getWorkingSetsString(CheckoutWizardProjectPage.this.workingSets);
                    if (CheckoutWizardProjectPage.this.workingSetsMap.get(workingSetsString) == null) {
                        CheckoutWizardProjectPage.this.workingSetsMap.put(workingSetsString, CheckoutWizardProjectPage.this.workingSets);
                        CheckoutWizardProjectPage.this.workingSetsCombo.add(workingSetsString);
                    }
                    CheckoutWizardProjectPage.this.workingSetsCombo.setText(workingSetsString);
                } else {
                    CheckoutWizardProjectPage.this.addToWorkingSetsButton.setSelection(false);
                    CheckoutWizardProjectPage.this.setWorkingSetsEnablement();
                }
            }
        });
        this.setWorkingSetsEnablement();
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        Class[] parameterTypes = new Class[]{IAdaptable.class, IWorkingSet[].class};
        Method addToWorkingSets = null;
        try {
            addToWorkingSets = manager.getClass().getMethod("addToWorkingSets", parameterTypes);
        }
        catch (Exception exception) {}
        if (addToWorkingSets == null) {
            this.addToWorkingSetsButton.setVisible(false);
            this.workingSetsLabel.setVisible(false);
            this.workingSetsCombo.setVisible(false);
            this.workingSetsSelectButton.setVisible(false);
        }
        this.setMessage(Policy.bind("CheckoutWizardProjectPage.text"));
        this.setControl((Control)outerContainer);
    }

    public IWorkingSet[] getWorkingSets() {
        if (this.addToWorkingSetsButton.getSelection()) {
            return this.workingSets;
        }
        return null;
    }

    private String getWorkingSetsString(IWorkingSet[] workingSets) {
        if (workingSets == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < workingSets.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(workingSets[i].getName());
            ++i;
        }
        return buffer.toString();
    }

    private void setWorkingSetsEnablement() {
        this.workingSetsLabel.setEnabled(this.addToWorkingSetsButton.getSelection());
        this.workingSetsCombo.setEnabled(this.addToWorkingSetsButton.getSelection());
        this.workingSetsSelectButton.setEnabled(this.addToWorkingSetsButton.getSelection());
    }

    private void setLocationEnablement() {
        this.locationLabel.setEnabled(!this.defaultButton.getSelection());
        this.locationText.setEnabled(!this.defaultButton.getSelection());
        this.browseButton.setEnabled(!this.defaultButton.getSelection());
    }

    private void setPageComplete() {
        this.setPageComplete(this.defaultButton.getSelection() || this.locationText.getText().trim().length() > 0);
    }

    public void setLocation() {
        this.locationText.setText(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
    }

    public String getLocation() {
        if (this.locationText == null) {
            CheckoutWizard wizard = (CheckoutWizard)this.getWizard();
            return String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + File.separator + wizard.getProjectName();
        }
        return this.locationText.getText().trim();
    }

    public String getCanonicalLocation() {
        return this.normalizeCase(this.getLocation());
    }

    private String normalizeCase(String location) {
        String caseFixed;
        File dir = new File(location);
        String original = dir.getAbsolutePath();
        try {
            caseFixed = dir.getCanonicalPath();
        }
        catch (IOException iOException) {
            return location;
        }
        if (caseFixed.equalsIgnoreCase(original)) {
            return caseFixed;
        }
        return location;
    }
}

