/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.settings;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.util.LinkList;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ProjectProperties {
    protected String label = "Issue Number:";
    protected String message;
    protected boolean number = false;
    protected String url;
    protected boolean warnIfNoIssue = false;
    protected boolean append = true;
    protected String logregex;
    private static final String URL = "://";
    private static final List<String> propertyFilterList = new ArrayList<String>();

    static {
        propertyFilterList.add("bugtraq:message");
        propertyFilterList.add("bugtraq:label");
        propertyFilterList.add("bugtraq:url");
        propertyFilterList.add("bugtraq:number");
        propertyFilterList.add("bugtraq:warnifnoissue");
        propertyFilterList.add("bugtraq:append");
        propertyFilterList.add("bugtraq:logregex");
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isNumber() {
        return this.number;
    }

    public void setNumber(boolean number) {
        this.number = number;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isWarnIfNoIssue() {
        return this.warnIfNoIssue;
    }

    public void setWarnIfNoIssue(boolean warnIfNoIssue) {
        this.warnIfNoIssue = warnIfNoIssue;
    }

    public String getLogregex() {
        return this.logregex;
    }

    public void setLogregex(String logregex) {
        this.logregex = logregex;
    }

    public String getResolvedMessage(String issue) {
        if (this.message == null || issue == null) {
            return null;
        }
        return this.message.replace("%BUGID%", issue);
    }

    public String getResolvedUrl(String issue) {
        if (this.url == null || issue == null) {
            return null;
        }
        return this.url.replace("%BUGID%", issue);
    }

    public LinkList getLinkList(String commitMessage) {
        int index;
        ArrayList<int[]> links = new ArrayList<int[]>();
        ArrayList<String> urls = new ArrayList<String>();
        ArrayList<String> texts = new ArrayList<String>();
        String bugID = "%BUGID%";
        if (this.logregex != null) {
            String[] resplit = this.logregex.split("\n");
            String re1 = resplit[0].trim();
            String re2 = resplit.length > 1 ? resplit[1].trim() : null;
            Pattern pre1 = Pattern.compile(re1);
            Matcher matcher1 = pre1.matcher(commitMessage);
            if (re2 == null) {
                while (matcher1.find()) {
                    int i = 0;
                    while (i < matcher1.groupCount()) {
                        int[] range = new int[]{matcher1.start(i + 1), matcher1.end(i + 1) - matcher1.start(i + 1)};
                        String url = this.getResolvedUrl(matcher1.group(i + 1));
                        if (url != null && url.trim().length() > 0) {
                            links.add(range);
                            urls.add(url);
                            texts.add(matcher1.group(i + 1));
                        }
                        ++i;
                    }
                }
            } else {
                Pattern pre2 = Pattern.compile(re2);
                while (matcher1.find()) {
                    Matcher matcher2 = pre2.matcher(matcher1.group());
                    while (matcher2.find()) {
                        int i = 0;
                        while (i < matcher2.groupCount()) {
                            int[] range = new int[]{matcher2.start(i + 1) + matcher1.start(), matcher2.end(i + 1) - matcher2.start(i + 1)};
                            String url = this.getResolvedUrl(matcher2.group(i + 1));
                            if (url != null && url.trim().length() > 0) {
                                links.add(range);
                                urls.add(url);
                                texts.add(matcher2.group(i + 1));
                            }
                            ++i;
                        }
                    }
                }
            }
        } else if (this.message != null && (index = this.message.indexOf(bugID)) != -1) {
            String remainder = null;
            remainder = this.message.length() > index + bugID.length() ? this.message.substring(index + bugID.length()) : "";
            String tag = this.message.substring(0, index);
            if ((index = commitMessage.indexOf(tag)) != -1) {
                String url;
                int start = index += tag.length();
                StringBuffer issue = new StringBuffer();
                while (index < commitMessage.length()) {
                    if (commitMessage.substring(index, index + 1).equals(",")) {
                        int[] range = new int[]{start, issue.length()};
                        url = this.getResolvedUrl(issue.toString());
                        if (url != null && url.trim().length() > 0) {
                            links.add(range);
                            urls.add(url);
                        }
                        start = index + 1;
                        issue = new StringBuffer();
                    } else {
                        if (commitMessage.substring(index, index + 1).equals("\n") || commitMessage.substring(index, index + 1).equals("\r") || commitMessage.substring(index).trim().equals(remainder.trim()) || commitMessage.substring(index).startsWith(String.valueOf(remainder) + "\n")) break;
                        if (commitMessage.substring(index, index + 1).equals(" ")) {
                            int lineIndex = commitMessage.indexOf("\n", index);
                            if (lineIndex == -1) {
                                lineIndex = commitMessage.indexOf("\r", index);
                            }
                            if (lineIndex != -1 && commitMessage.substring(index, lineIndex - 1).trim().length() == 0) break;
                        }
                        issue.append(commitMessage.substring(index, index + 1));
                    }
                    ++index;
                }
                int[] range = new int[]{start, issue.length()};
                url = this.getResolvedUrl(issue.toString());
                if (url != null && url.trim().length() > 0) {
                    links.add(range);
                    urls.add(url);
                    texts.add(issue.toString());
                }
            }
        }
        LinkList urlLinks = ProjectProperties.getUrls(commitMessage);
        int[][] urlRanges = urlLinks.getLinkRanges();
        String[] urlUrls = urlLinks.getUrls();
        int i = 0;
        while (i < urlRanges.length) {
            links.add(urlRanges[i]);
            urls.add(urlUrls[i]);
            ++i;
        }
        int[][] linkRanges = new int[links.size()][2];
        links.toArray((T[])linkRanges);
        String[] urlArray = new String[urls.size()];
        urls.toArray(urlArray);
        String[] textArray = new String[texts.size()];
        texts.toArray(textArray);
        LinkList linkList = new LinkList(linkRanges, urlArray, textArray);
        return linkList;
    }

    /*
     * Unable to fully structure code
     */
    public static LinkList getUrls(String s) {
        max = 0;
        i = -1;
        if (s != null) {
            max = s.length();
            i = s.indexOf("://");
        }
        linkRanges = new ArrayList<int[]>();
        links = new ArrayList<String>();
        ** GOTO lbl30
        {
            block5: {
                if (!Character.isWhitespace(s.charAt(i)) && !s.substring(i, i + 1).equals("\n")) break block5;
                ++i;
                ** GOTO lbl16
            }
            --i;
            do {
                if (i != -1) continue block0;
lbl16:
                // 2 sources

                start = i < 0 ? 0 : i;
                found = false;
                i += "://".length();
                while (!found && i < max) {
                    found = Character.isWhitespace(s.charAt(i)) != false || s.substring(i, i + 1).equals("\n") != false;
                    ++i;
                }
                if (i != max) {
                    --i;
                }
                linkRanges.add(new int[]{start, i - start});
                links.add(s.substring(start, i));
                i = s.indexOf("://", i);
lbl30:
                // 2 sources

            } while (i != -1);
        }
        return new LinkList((int[][])linkRanges.toArray((T[])new int[linkRanges.size()][2]), links.toArray(new String[links.size()]), null);
    }

    public String validateIssue(String issue) {
        if (this.number && !this.hasOnlyDigits(issue)) {
            return Policy.bind("CommitDialog.number", this.label);
        }
        return null;
    }

    private boolean hasOnlyDigits(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != ',' && !Character.isDigit(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return "bugtraq:label: " + this.label + "\n" + "bugtraq:logregex: " + this.logregex + "\n" + "bugtraq:message: " + this.message + "\n" + "bugtraq:number: " + this.number + "\n" + "bugtraq:url: " + this.url + "\n" + "bugtraq:warnifnoissue: " + this.warnIfNoIssue + "\n" + "bugtraq:append: " + this.append;
    }

    private static ProjectProperties getProjectProperties(File file, ISVNLocalResource svnResource) throws SVNException {
        ISVNProperty[] bugtraqProperties;
        if (file == null) {
            return null;
        }
        ISVNLocalResource parent = svnResource;
        while (parent != null) {
            if (parent.exists() && parent.isManaged() && !parent.getStatusFromCache().isDeleted()) break;
            parent = parent.getParent();
        }
        if (parent == null || !parent.exists() || !parent.isManaged() || parent.getStatusFromCache().isDeleted()) {
            return null;
        }
        String message = null;
        String logregex = null;
        String label = null;
        String url = null;
        boolean number = false;
        boolean warnifnoissue = false;
        boolean append = true;
        ISVNProperty[] iSVNPropertyArray = bugtraqProperties = parent.getPropertiesIncludingInherited(false, true, propertyFilterList);
        int n = 0;
        int n2 = iSVNPropertyArray.length;
        while (n < n2) {
            ISVNProperty prop = iSVNPropertyArray[n];
            if (prop.getName().equals("bugtraq:message")) {
                message = prop.getValue();
            } else if (prop.getName().equals("bugtraq:logregex")) {
                logregex = prop.getValue();
            } else if (prop.getName().equals("bugtraq:label")) {
                label = prop.getValue();
            } else if (prop.getName().equals("bugtraq:url")) {
                url = ProjectProperties.resolveUrl(prop.getValue(), svnResource);
            } else if (prop.getName().equals("bugtraq:number")) {
                number = prop.getValue().equalsIgnoreCase("true");
            } else if (prop.getName().equals("bugtraq:warnifnoissue")) {
                warnifnoissue = prop.getValue().equalsIgnoreCase("true");
            } else if (prop.getName().equals("bugtraq:append")) {
                append = prop.getValue().equalsIgnoreCase("true");
            }
            ++n;
        }
        ProjectProperties projectProperties = null;
        if (message != null || logregex != null) {
            projectProperties = new ProjectProperties();
            projectProperties.setMessage(message);
            projectProperties.setLogregex(logregex);
            if (label != null) {
                projectProperties.setLabel(label);
            }
            projectProperties.setUrl(url);
            projectProperties.setNumber(number);
            projectProperties.setWarnIfNoIssue(warnifnoissue);
            projectProperties.setAppend(append);
        }
        return projectProperties;
    }

    public static ProjectProperties getProjectProperties(IResource resource) throws SVNException {
        if (resource == null || resource.getLocation() == null) {
            return null;
        }
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
        if (svnResource != null) {
            return ProjectProperties.getProjectProperties(new File(resource.getLocation().toString()), svnResource);
        }
        return null;
    }

    private static String resolveUrl(String url, ISVNLocalResource svnResource) {
        String resolvedUrl = null;
        if (url.startsWith("^/")) {
            SVNUrl repositoryUrl = svnResource.getRepository().getUrl();
            String path = url.substring(1);
            while (path.startsWith("/..")) {
                if (repositoryUrl.getParent() == null) break;
                repositoryUrl = repositoryUrl.getParent();
                path = path.substring(3);
            }
            resolvedUrl = repositoryUrl + path;
        } else if (url.startsWith("/")) {
            String resourceUrl = svnResource.getUrl().toString();
            String protocol = svnResource.getUrl().getProtocol();
            int start = protocol.length();
            while (resourceUrl.substring(start, start + 1).equals(":") || resourceUrl.substring(start, start + 1).equals("/")) {
                ++start;
            }
            int end = resourceUrl.indexOf("/", start);
            resolvedUrl = end == -1 ? String.valueOf(resourceUrl) + url : String.valueOf(resourceUrl.substring(0, end)) + url;
        } else {
            resolvedUrl = url;
        }
        return resolvedUrl;
    }

    public static ProjectProperties getProjectProperties(ISVNRemoteResource remoteResource) throws SVNException {
        return ProjectProperties.getProjectProperties(remoteResource.getResource());
    }
}

