/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.nature;

import java.util.ArrayList;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CheckstyleNature
implements IProjectNature {
    public static final String NATURE_ID = "net.sf.eclipsecs.core.CheckstyleNature";
    private IProject mProject;

    public void configure() throws CoreException {
        IProjectDescription description = this.mProject.getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("net.sf.eclipsecs.core.CheckstyleBuilder")) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            ICommand command = description.newCommand();
            command.setBuilderName("net.sf.eclipsecs.core.CheckstyleBuilder");
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, commands.length);
            newCommands[commands.length] = command;
            description.setBuildSpec(newCommands);
            this.ensureProjectFileWritable();
            this.mProject.setDescription(description, null);
        }
    }

    private void ensureProjectFileWritable() {
        IFile projectFile = this.mProject.getFile(".project");
        if (projectFile.isReadOnly()) {
            projectFile.setReadOnly(false);
        }
    }

    public void deconfigure() throws CoreException {
        IProjectDescription description = this.mProject.getDescription();
        ICommand[] commands = description.getBuildSpec();
        ArrayList<ICommand> newCommandsVec = new ArrayList<ICommand>();
        int i = 0;
        while (i < commands.length) {
            if (!commands[i].getBuilderName().equals("net.sf.eclipsecs.core.CheckstyleBuilder")) {
                newCommandsVec.add(commands[i]);
            }
            ++i;
        }
        ICommand[] newCommands = newCommandsVec.toArray(new ICommand[newCommandsVec.size()]);
        description.setBuildSpec(newCommands);
        this.ensureProjectFileWritable();
        this.mProject.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        this.getProject().deleteMarkers("net.sf.eclipsecs.core.CheckstyleMarker", true, 2);
    }

    public IProject getProject() {
        return this.mProject;
    }

    public void setProject(IProject project) {
        this.mProject = project;
    }

    public static boolean hasCorrectBuilderOrder(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int javaBuilderIndex = -1;
        int checkstyleBuilderIndex = -1;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("net.sf.eclipsecs.core.CheckstyleBuilder")) {
                checkstyleBuilderIndex = i;
            } else if (commands[i].getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) {
                javaBuilderIndex = i;
            }
            ++i;
        }
        return javaBuilderIndex < checkstyleBuilderIndex;
    }
}

