/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.configtypes;

import com.puppycrawl.tools.checkstyle.PropertyResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.PropertyResourceBundle;
import net.sf.eclipsecs.core.config.CheckstyleConfigurationFile;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.configtypes.ClasspathVariableResolver;
import net.sf.eclipsecs.core.config.configtypes.IConfigurationType;
import net.sf.eclipsecs.core.config.configtypes.MultiPropertyResolver;
import net.sf.eclipsecs.core.config.configtypes.ResolvablePropertyResolver;
import net.sf.eclipsecs.core.config.configtypes.ResourceBundlePropertyResolver;
import net.sf.eclipsecs.core.config.configtypes.StandardPropertyResolver;
import net.sf.eclipsecs.core.config.configtypes.SystemPropertyResolver;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class ConfigurationType
implements IConfigurationType {
    private String mName;
    private String mInternalName;
    private boolean mIsCreatable;
    private boolean mIsEditable;
    private boolean mIsConfigurable;

    @Override
    public void initialize(String name, String internalName, String definingPluginId, boolean creatable, boolean editable, boolean configurable) {
        this.mName = name;
        this.mInternalName = internalName;
        this.mIsCreatable = creatable;
        this.mIsEditable = editable;
        this.mIsConfigurable = configurable;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getInternalName() {
        return this.mInternalName;
    }

    @Override
    public boolean isCreatable() {
        return this.mIsCreatable;
    }

    @Override
    public boolean isEditable() {
        return this.mIsEditable;
    }

    @Override
    public boolean isConfigurable(ICheckConfiguration checkConfiguration) {
        return this.mIsConfigurable;
    }

    @Override
    public URL getResolvedConfigurationFileURL(ICheckConfiguration checkConfiguration) throws CheckstylePluginException {
        URL url = null;
        try {
            url = this.resolveLocation(checkConfiguration);
        }
        catch (IOException e) {
            CheckstylePluginException.rethrow(e);
        }
        return url;
    }

    @Override
    public CheckstyleConfigurationFile getCheckstyleConfiguration(ICheckConfiguration checkConfiguration) throws CheckstylePluginException {
        CheckstyleConfigurationFile data = new CheckstyleConfigurationFile();
        try {
            data.setResolvedConfigFileURL(this.resolveLocation(checkConfiguration));
            URLConnection connection = data.getResolvedConfigFileURL().openConnection();
            connection.connect();
            data.setModificationStamp(connection.getLastModified());
            byte[] configurationFileData = this.getBytesFromURLConnection(connection);
            data.setCheckConfigFileBytes(configurationFileData);
            byte[] additionalPropertiesBytes = this.getAdditionPropertiesBundleBytes(data.getResolvedConfigFileURL());
            data.setAdditionalPropertyBundleBytes(additionalPropertiesBytes);
            PropertyResolver resolver = this.getPropertyResolver(checkConfiguration, data);
            data.setPropertyResolver(resolver);
        }
        catch (IOException e) {
            CheckstylePluginException.rethrow(e);
        }
        return data;
    }

    protected abstract URL resolveLocation(ICheckConfiguration var1) throws IOException;

    protected byte[] getAdditionPropertiesBundleBytes(URL checkConfigURL) {
        String location = checkConfigURL.toString();
        String propsLocation = null;
        int lastPointIndex = location.lastIndexOf(".");
        propsLocation = lastPointIndex > -1 ? location.substring(0, lastPointIndex) : location;
        propsLocation = String.valueOf(propsLocation) + ".properties";
        try {
            URL propertyFileURL = new URL(propsLocation);
            URLConnection connection = propertyFileURL.openConnection();
            return this.getBytesFromURLConnection(connection);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected PropertyResolver getPropertyResolver(ICheckConfiguration config, CheckstyleConfigurationFile configFile) throws IOException {
        MultiPropertyResolver multiResolver = new MultiPropertyResolver();
        multiResolver.addPropertyResolver(new ResolvablePropertyResolver(config));
        File f = FileUtils.toFile((URL)configFile.getResolvedConfigFileURL());
        if (f != null) {
            multiResolver.addPropertyResolver(new StandardPropertyResolver(f.toString()));
        } else {
            multiResolver.addPropertyResolver(new StandardPropertyResolver(configFile.getResolvedConfigFileURL().toString()));
        }
        multiResolver.addPropertyResolver(new ClasspathVariableResolver());
        multiResolver.addPropertyResolver(new SystemPropertyResolver());
        if (configFile.getAdditionalPropertiesBundleStream() != null) {
            PropertyResourceBundle bundle = new PropertyResourceBundle(configFile.getAdditionalPropertiesBundleStream());
            multiResolver.addPropertyResolver(new ResourceBundlePropertyResolver(bundle));
        }
        return multiResolver;
    }

    protected byte[] getBytesFromURLConnection(URLConnection connection) throws IOException {
        byte[] configurationFileData = null;
        InputStream in = null;
        try {
            in = connection.getInputStream();
            configurationFileData = IOUtils.toByteArray((InputStream)in);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return configurationFileData;
    }

    @Override
    public void notifyCheckConfigRemoved(ICheckConfiguration checkConfiguration) throws CheckstylePluginException {
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ConfigurationType)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ConfigurationType rhs = (ConfigurationType)obj;
        return new EqualsBuilder().append((Object)this.mName, (Object)rhs.mName).append((Object)this.mInternalName, (Object)rhs.mInternalName).append(this.mIsCreatable, rhs.mIsCreatable).append(this.mIsEditable, rhs.mIsEditable).append(this.mIsConfigurable, rhs.mIsConfigurable).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(82713903, 1000003).append((Object)this.mName).append((Object)this.mInternalName).append(this.mIsCreatable).append(this.mIsEditable).append(this.mIsConfigurable).toHashCode();
    }
}

