/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.directclickthrough.servlet;

import com.atlassian.connector.eclipse.internal.directclickthrough.ui.DirectClickThroughImages;
import com.atlassian.theplugin.commons.util.MiscUtil;
import com.atlassian.theplugin.commons.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.OpenRepositoryTaskJob;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class DirectClickThroughServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        if ("/icon".equals(path)) {
            this.writeIcon(resp);
            return;
        }
        DirectClickThroughServlet.bringEclipseToFront();
        if ("/file".equals(path)) {
            this.writeIcon(resp);
            this.handleOpenFileRequest(req);
        } else if ("/issue".equals(path)) {
            this.writeIcon(resp);
            this.handleOpenIssueRequest(req);
        } else if ("/build".equals(path)) {
            this.writeIcon(resp);
            this.handleOpenBuildRequest(req);
        } else {
            resp.setStatus(204);
            StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.directclickthrough.ui", NLS.bind((String)"Direct Click Through server received unknown command: [{0}]", (Object)path)));
        }
    }

    private void handleOpenFileRequest(HttpServletRequest req) {
        String file = StringUtil.removePrefixSlashes((String)req.getParameter("file"));
        String path = StringUtil.removeSuffixSlashes((String)req.getParameter("path"));
        String vcsRoot = StringUtil.removeSuffixSlashes((String)req.getParameter("vcs_root"));
        String line = req.getParameter("line");
        if (file != null) {
            this.openRequestedFile(path, file, vcsRoot, line);
        }
    }

    private void openRequestedFile(final String path, final String file, String vcsRoot, final String line) {
        final ArrayList resources = MiscUtil.buildArrayList();
        final int[] matchLevel = new int[1];
        Job searchAndOpenJob = new Job("Search and open files requested using Direct Click Through"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Searching for files", -1);
                try {
                    try {
                        ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceVisitor(){

                            private int matchingLastSegments(IPath firstPath, IPath secondPath) {
                                int firstPathLen = firstPath.segmentCount();
                                int secondPathLen = secondPath.segmentCount();
                                int max = Math.min(firstPathLen, secondPathLen);
                                int count = 0;
                                int i = 1;
                                while (i <= max) {
                                    if (!firstPath.segment(firstPathLen - i).equals(secondPath.segment(secondPathLen - i))) {
                                        return count;
                                    }
                                    ++count;
                                    ++i;
                                }
                                return count;
                            }

                            public boolean visit(IResource resource) throws CoreException {
                                if (!(resource instanceof IFile)) {
                                    return true;
                                }
                                int matchCount = this.matchingLastSegments((IPath)new Path(path == null ? file : String.valueOf(path) + "/" + file), resource.getLocation());
                                if (matchCount > 0) {
                                    if (matchCount > matchLevel[0]) {
                                        resources.clear();
                                        matchLevel[0] = matchCount;
                                    }
                                    if (matchCount == matchLevel[0]) {
                                        resources.add(resource);
                                    }
                                }
                                return true;
                            }
                        });
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, "com.atlassian.connector.eclipse.directclickthrough.ui", "Direct Click Through server failed to find matching files", (Throwable)e);
                        monitor.done();
                        return status;
                    }
                }
                finally {
                    monitor.done();
                }
                return new Status(0, "com.atlassian.connector.eclipse.directclickthrough.ui", "Search finished");
            }
        };
        searchAndOpenJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    return;
                }
                if (resources.size() > 0) {
                    if (resources.size() == 1) {
                        DirectClickThroughServlet.this.openFile((IResource)resources.iterator().next(), line);
                    } else {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                Object[] result;
                                ListDialog ld = new ListDialog(WorkbenchUtil.getShell());
                                ld.setAddCancelButton(true);
                                ld.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                                ld.setInput((Object)resources.toArray(new IResource[resources.size()]));
                                ld.setTitle("Select File to Open");
                                ld.setLabelProvider((ILabelProvider)new LabelProvider(){

                                    public String getText(Object element) {
                                        if (element instanceof IResource) {
                                            return ((IResource)element).getFullPath().toString();
                                        }
                                        return super.getText(element);
                                    }
                                });
                                ld.setMessage("Direct Click Through request matches multiple files.\nPlease select apropriate file that will be open in editor.");
                                if (ld.open() == 0 && (result = ld.getResult()) != null && result.length > 0) {
                                    Object[] objectArray = result;
                                    int n = result.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Object selected = objectArray[n2];
                                        if (selected instanceof IResource) {
                                            DirectClickThroughServlet.this.openFile((IResource)selected, line);
                                        }
                                        ++n2;
                                    }
                                }
                            }
                        });
                    }
                } else {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            new MessageDialog(WorkbenchUtil.getShell(), "Unable to open file", null, "Unable to open file requested using Direct Click Through. Either file is missing or all projects are closed.", 2, new String[]{IDialogConstants.OK_LABEL}, 0).open();
                        }
                    });
                }
            }
        });
        searchAndOpenJob.schedule();
    }

    private void openFile(final IResource resource, final String line) {
        Assert.isNotNull((Object)resource);
        if (resource.getType() != 1) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IEditorPart editor;
                try {
                    editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)resource));
                }
                catch (PartInitException e1) {
                    StatusHandler.log((IStatus)e1.getStatus());
                    return;
                }
                if (editor != null && line != null && line.length() > 0 && editor instanceof ITextEditor) {
                    try {
                        int l = Integer.parseInt(line);
                        DirectClickThroughServlet.this.gotoLine((ITextEditor)editor, l);
                    }
                    catch (NumberFormatException e) {
                        StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.directclickthrough.ui", NLS.bind((String)"Wrong line number format when requesting to open file in the IDE [{0}]", (Object)line), (Throwable)e));
                        return;
                    }
                }
            }
        });
    }

    private void gotoLine(ITextEditor editor, int line) {
        IDocumentProvider provider = editor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)editor.getEditorInput());
        try {
            int start = document.getLineOffset(line);
            editor.selectAndReveal(start, 0);
            IWorkbenchPage page = editor.getSite().getPage();
            page.activate((IWorkbenchPart)editor);
        }
        catch (BadLocationException badLocationException) {}
    }

    private void handleOpenBuildRequest(HttpServletRequest req) {
        String buildKey = req.getParameter("build_key");
        String buildNumber = req.getParameter("build_number");
        final String repositoryUrl = req.getParameter("server_url");
        req.getParameter("test_package");
        req.getParameter("test_class");
        req.getParameter("test_method");
        if (buildKey == null || buildKey.length() == 0 || repositoryUrl == null || repositoryUrl.length() == 0 || buildNumber == null || buildNumber.length() == 0) {
            StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.directclickthrough.ui", "Cannot open build: build_key or build_number or server_url parameter is null"));
        }
        try {
            Class<?> corePluginClass = Class.forName("com.atlassian.connector.eclipse.internal.bamboo.core.BambooCorePlugin");
            String connectorKind = (String)corePluginClass.getDeclaredField("CONNECTOR_KIND").get(null);
            IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
            TaskRepository taskRepository = repositoryManager.getRepository(connectorKind, repositoryUrl);
            if (taskRepository == null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError(null, (String)Messages.OpenRepositoryTaskJob_Repository_Not_Found, (String)(String.valueOf(MessageFormat.format(Messages.OpenRepositoryTaskJob_Could_not_find_repository_configuration_for_X, repositoryUrl)) + "\n" + MessageFormat.format(Messages.OpenRepositoryTaskJob_Please_set_up_repository_via_X, Messages.TasksUiPlugin_Task_Repositories)));
                    }
                });
                return;
            }
            Class<?> openBuildJobClass = Class.forName("com.atlassian.connector.eclipse.internal.bamboo.ui.operations.OpenBambooBuildJob");
            Constructor<?> openBuildJobConstructor = openBuildJobClass.getConstructor(String.class, Integer.TYPE, TaskRepository.class);
            Job openBambooBuildJob = (Job)openBuildJobConstructor.newInstance(buildKey, Integer.valueOf(buildNumber), taskRepository);
            openBambooBuildJob.schedule();
        }
        catch (Exception exception) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    new MessageDialog(WorkbenchUtil.getShell(), "Unable to handle request", null, "Direct Click Through failed to open issue because Atlassian Bamboo Integration is missing.", 2, new String[]{IDialogConstants.OK_LABEL}, 0).open();
                }
            });
        }
    }

    private void handleOpenIssueRequest(HttpServletRequest req) {
        String taskId = req.getParameter("issue_key");
        String repositoryUrl = req.getParameter("server_url");
        if (taskId == null || repositoryUrl == null) {
            StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.directclickthrough.ui", "Cannot open issue: issue_key or server_url parameter is null"));
        }
        try {
            Class<?> cls = Class.forName("org.eclipse.mylyn.internal.jira.core.JiraCorePlugin");
            Field connectorKindField = cls.getDeclaredField("CONNECTOR_KIND");
            String connectorKind = (String)connectorKindField.get(null);
            IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
            AbstractRepositoryConnector connector = repositoryManager.getRepositoryConnector(connectorKind);
            String taskUrl = connector == null ? null : connector.getTaskUrl(repositoryUrl, taskId);
            new OpenRepositoryTaskJob(connectorKind, repositoryUrl, taskId, taskUrl, null).schedule();
        }
        catch (Exception exception) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    new MessageDialog(WorkbenchUtil.getShell(), "Unable to handle request", null, "Direct Click Through failed to open issue because Mylyn JIRA Connector is missing.", 2, new String[]{IDialogConstants.OK_LABEL}, 0).open();
                }
            });
        }
    }

    private static Shell getModalDialogOpen(Shell shell) {
        Shell[] shells = shell.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell dialog = shells[i];
            if ((dialog.getStyle() & 0x38000) > 0) {
                return dialog;
            }
            ++i;
        }
        return null;
    }

    private static void bringEclipseToFront() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                if (windows == null || windows.length == 0) {
                    return;
                }
                Shell shell = windows[0].getShell();
                if (shell != null) {
                    Shell dialog = DirectClickThroughServlet.getModalDialogOpen(shell);
                    if (shell.getMinimized()) {
                        shell.setMinimized(false);
                        if (dialog != null) {
                            dialog.setFocus();
                        }
                    }
                    if (dialog == null) {
                        shell.forceActive();
                    }
                }
            }
        });
    }

    private void writeIcon(HttpServletResponse response) throws IOException {
        BufferedInputStream icon = new BufferedInputStream(new URL(DirectClickThroughImages.BASE_URL, "obj16/eclipse.gif").openStream());
        try {
            response.setContentType("image/gif");
            response.setStatus(200);
            ServletOutputStream output = response.getOutputStream();
            int b = ((InputStream)icon).read();
            while (b != -1) {
                output.write(b);
                b = ((InputStream)icon).read();
            }
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)icon).close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            ((InputStream)icon).close();
        }
        catch (Exception exception) {}
    }
}

