/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util;

import java.io.InputStream;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.testng.collections.Maps;
import org.testng.eclipse.TestNGPlugin;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SuiteFileValidator {
    private static final SAXParserFactory SAX_FACTORY = SAXParserFactory.newInstance();
    private static SAXParser SAXPARSER;
    private static final Pattern SUITE_REGEXP;
    private static final Pattern TAG_REGEXP;
    private static Map<IFile, Boolean> s_cache;

    static {
        SUITE_REGEXP = Pattern.compile("<suite.*");
        TAG_REGEXP = Pattern.compile("<[^>?!]+>");
        s_cache = Maps.newHashMap();
    }

    public static boolean isSuiteDefinition(IFile file) throws CoreException {
        return SuiteFileValidator.isSuiteDefinition(file, false);
    }

    public static boolean isSuiteDefinition(IFile file, boolean xmlOnly) throws CoreException {
        if (s_cache.containsKey(file)) {
            return true;
        }
        boolean result = false;
        if (!xmlOnly && file.getName().endsWith("yaml")) {
            result = true;
        }
        if (!result) {
            result = SuiteFileValidator.isSuiteDefinition(file.getContents());
        }
        if (result) {
            s_cache.put(file, Boolean.TRUE);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private static boolean isSuiteDefinition(InputStream is) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void ppp(String s) {
        System.out.println("[SuiteFileValidator] " + s);
    }

    private static SAXParser getParser() {
        if (SAXPARSER == null) {
            try {
                SAX_FACTORY.setValidating(false);
                SAXPARSER = SAX_FACTORY.newSAXParser();
            }
            catch (ParserConfigurationException pce) {
                TestNGPlugin.log(pce);
            }
            catch (SAXException saxe) {
                TestNGPlugin.log(saxe);
            }
        }
        return SAXPARSER;
    }

    private static class SuiteHandler
    extends DefaultHandler {
        protected boolean m_isValid = false;
        protected int m_elementCount = 0;

        private SuiteHandler() {
        }

        public boolean isValid() {
            return this.m_isValid;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            InputSource result = null;
            if ("http://testng.org/testng-1.0.dtd".equals(publicId)) {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("testng-1.0.dtd");
                if (is == null) {
                    is = Thread.currentThread().getContextClassLoader().getResourceAsStream("testng-1.0.dtd");
                    if (is == null) {
                        System.out.println("WARNING: couldn't find in classpath http://testng.org/testng-1.0.dtd\nFetching it from the Web site.");
                        try {
                            result = super.resolveEntity(systemId, publicId);
                        }
                        catch (Exception e) {
                            throw new SAXException(e);
                        }
                    } else {
                        result = new InputSource(is);
                    }
                } else {
                    result = new InputSource(is);
                }
            } else {
                try {
                    result = super.resolveEntity(systemId, publicId);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            return result;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.m_elementCount++ == 0 && "suite".equals(qName)) {
                this.m_isValid = true;
            }
        }
    }
}

