/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.preferences;

import java.io.File;
import org.eclipse.debug.internal.ui.preferences.BooleanFieldEditor2;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.util.ResourceUtil;

public class WorkspacePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private FSBrowseDirectoryFieldEditor m_outputdir;
    private BooleanFieldEditor2 m_absolutePath;
    private BooleanFieldEditor2 m_disabledDefaultListeners;
    private BooleanFieldEditor2 m_showViewWhenTestsComplete;
    private BooleanFieldEditor2 m_useProjectJar;
    private FileFieldEditor m_xmlTemplateFile;
    private StringFieldEditor m_excludedStackTraces;
    private StringFieldEditor m_preDefinedListeners;

    public WorkspacePreferencePage() {
        super(1);
        this.setPreferenceStore(TestNGPlugin.getDefault().getPreferenceStore());
        this.setDescription("TestNG workbench preferences");
    }

    public void createFieldEditors() {
        Composite parentComposite = this.getFieldEditorParent();
        this.m_outputdir = new FSBrowseDirectoryFieldEditor(".outdir", "Output directory:", parentComposite);
        this.m_outputdir.fillIntoGrid(parentComposite, 3);
        Button btn = this.m_outputdir.getChangeControl(parentComposite);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                WorkspacePreferencePage.this.m_absolutePath.getChangeControl(WorkspacePreferencePage.this.getFieldEditorParent()).setSelection(true);
            }
        });
        this.m_absolutePath = new BooleanFieldEditor2(".absolutepath", "Absolute output path", 0, parentComposite);
        this.m_outputdir.setAbsolutePathVerifier(this.m_absolutePath);
        this.m_disabledDefaultListeners = new BooleanFieldEditor2(".disabledListeners", "Disable default listeners", 0, parentComposite);
        this.m_showViewWhenTestsComplete = new BooleanFieldEditor2("showViewWhenTestComplete", "Show view when tests complete", 0, parentComposite);
        this.m_useProjectJar = new BooleanFieldEditor2("_TESTNG_ECLIPSE.useProjectJar", ResourceUtil.getString("TestNGPropertyPage.useProjectTestNGJar"), 0, parentComposite);
        this.m_xmlTemplateFile = new FileFieldEditor("xmlTemplateFile", "Template XML file:", false, 1, parentComposite);
        this.m_xmlTemplateFile.setEmptyStringAllowed(true);
        this.m_xmlTemplateFile.fillIntoGrid(parentComposite, 3);
        this.m_excludedStackTraces = new StringFieldEditor("excludedStackTraces", "Excluded stack traces:", parentComposite);
        this.m_excludedStackTraces.fillIntoGrid(parentComposite, 3);
        GridDataFactory.fillDefaults().grab(true, false).hint(this.convertWidthInCharsToPixels(36), -1).applyTo((Control)this.m_excludedStackTraces.getTextControl(parentComposite));
        this.m_preDefinedListeners = new StringFieldEditor("preDefinedListeners", "Pre Defined Listeners", parentComposite);
        this.addField((FieldEditor)this.m_outputdir);
        this.addField((FieldEditor)this.m_absolutePath);
        this.addField((FieldEditor)this.m_disabledDefaultListeners);
        this.addField((FieldEditor)this.m_showViewWhenTestsComplete);
        this.addField((FieldEditor)this.m_useProjectJar);
        this.addField((FieldEditor)this.m_xmlTemplateFile);
        this.addField((FieldEditor)this.m_excludedStackTraces);
        this.addField((FieldEditor)this.m_preDefinedListeners);
    }

    public void init(IWorkbench workbench) {
    }

    private static class FSBrowseDirectoryFieldEditor
    extends DirectoryFieldEditor {
        BooleanFieldEditor2 absolutePath;

        public FSBrowseDirectoryFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void setAbsolutePathVerifier(BooleanFieldEditor2 isAbsolute) {
            this.absolutePath = isAbsolute;
        }

        public Button getChangeControl(Composite parent) {
            return super.getChangeControl(parent);
        }

        protected boolean doCheckState() {
            String fileName = this.getTextControl().getText();
            if ((fileName = fileName.trim()).length() == 0 && this.isEmptyStringAllowed()) {
                return true;
            }
            if (this.absolutePath.getBooleanValue()) {
                File file = new File(fileName);
                return file.isDirectory();
            }
            return true;
        }
    }
}

