/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch.components;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.testng.eclipse.launch.components.BaseVisitor;

public class AnnotationVisitor
extends BaseVisitor {
    private static final String JDK15_ANNOTATION = "jdk15";

    public boolean visit(MethodDeclaration node) {
        if (this.m_typeIsTest) {
            this.addTestMethod(node, JDK15_ANNOTATION);
        }
        return true;
    }

    public boolean visit(MarkerAnnotation node) {
        ASTNode parent = node.getParent();
        if (this.isTestAnnotation(node.getTypeName().toString())) {
            if (parent instanceof MethodDeclaration) {
                this.addTestMethod((MethodDeclaration)parent, JDK15_ANNOTATION);
            } else if (parent instanceof TypeDeclaration) {
                this.m_typeIsTest = true;
                this.m_annotationType = JDK15_ANNOTATION;
            }
        } else if (this.isFactoryAnnotation(node.getTypeName().toString()) && parent instanceof MethodDeclaration) {
            this.m_annotationType = JDK15_ANNOTATION;
            this.addFactoryMethod((MethodDeclaration)parent, JDK15_ANNOTATION);
        }
        return false;
    }

    public boolean visit(NormalAnnotation node) {
        if (this.isTestAnnotation(node.getTypeName().toString())) {
            ASTNode parent = node.getParent();
            if (parent instanceof MethodDeclaration) {
                this.addTestMethod((MethodDeclaration)parent, JDK15_ANNOTATION);
            } else if (parent instanceof TypeDeclaration) {
                this.m_typeIsTest = true;
                this.m_annotationType = JDK15_ANNOTATION;
            }
            List pairs = node.values();
            for (MemberValuePair mvp : pairs) {
                SimpleName attribute = mvp.getName();
                String name = attribute.getFullyQualifiedName();
                if (!"groups".equals(name)) continue;
                Expression value = mvp.getValue();
                if (value instanceof ArrayInitializer) {
                    ArrayInitializer ai = (ArrayInitializer)value;
                    List expressions = ai.expressions();
                    for (Expression e : expressions) {
                        Object v = e.resolveConstantExpressionValue();
                        String g = v != null ? v.toString() : e.toString();
                        this.addGroup(g);
                    }
                    continue;
                }
                if (value instanceof Name) {
                    Object v = value.resolveConstantExpressionValue();
                    String boundValue = v != null ? v.toString() : value.toString();
                    this.addGroup(boundValue);
                    continue;
                }
                if (!(value instanceof StringLiteral)) continue;
                this.addGroup(value.toString());
            }
        } else if (this.isFactoryAnnotation(node.getTypeName().toString()) && node.getParent() instanceof MethodDeclaration) {
            this.m_annotationType = JDK15_ANNOTATION;
            this.addFactoryMethod((MethodDeclaration)node.getParent(), JDK15_ANNOTATION);
        }
        return false;
    }

    public boolean isTestAnnotation(String annotation) {
        return "Test".equals(annotation) || annotation.endsWith(".Test");
    }

    public boolean isFactoryAnnotation(String annotation) {
        return "Factory".equals(annotation) || annotation.endsWith(".Factory");
    }

    public static void ppp(String s) {
        System.out.println("[AnnotationVisitor] " + s);
    }
}

