/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.model.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.StructuredActivity;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.graph.model.commands.AbstractTextCommand;
import org.w3c.dom.Node;

public class DeleteCommand
extends AbstractTextCommand {
    private Activity child;
    private StructuredActivity parent;
    private IDOMElement childElement;
    private IDOMElement parentElement;
    private final List<Transition> sourceConnections = new ArrayList<Transition>();
    private final List<Transition> targetConnections = new ArrayList<Transition>();

    public DeleteCommand(ITextEditor textEditor) {
        super(textEditor);
    }

    public boolean canExecute() {
        this.childElement = this.child.getInput();
        this.parentElement = this.parent.getInput();
        if (this.childElement == null || this.parentElement == null) {
            return false;
        }
        if (this.childElement.getOwnerDocument() == null || this.childElement.getParentNode() == null || this.parentElement.getParentNode() == null) {
            return false;
        }
        Node ancestor = ((NodeImpl)this.childElement.getOwnerDocument()).getCommonAncestor((Node)this.childElement);
        if (ancestor == null) {
            return false;
        }
        return super.canExecute();
    }

    private void deleteConnections(Activity a) {
        if (a instanceof StructuredActivity) {
            List<Activity> children = ((StructuredActivity)a).getChildren();
            int i = 0;
            while (i < children.size()) {
                this.deleteConnections(children.get(i));
                ++i;
            }
        }
        this.sourceConnections.addAll(a.getIncomingTransitions());
        int i = 0;
        while (i < this.sourceConnections.size()) {
            Transition t = this.sourceConnections.get(i);
            t.source.removeOutgoing(t);
            a.removeIncoming(t);
            ++i;
        }
        this.targetConnections.addAll(a.getOutgoingTransitions());
        i = 0;
        while (i < this.targetConnections.size()) {
            Transition t = this.targetConnections.get(i);
            t.target.removeIncoming(t);
            a.removeOutgoing(t);
            ++i;
        }
    }

    public void execute() {
        if (this.canExecute()) {
            this.primExecute();
        }
    }

    protected void primExecute() {
        this.deleteConnections(this.child);
        this.parent.removeChild(this.child);
    }

    public void setChild(Activity a) {
        this.child = a;
    }

    public void setParent(StructuredActivity sa) {
        this.parent = sa;
    }
}

