/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.SelectionModel;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.AbstractChooseOneSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.UIConstants;
import org.springsource.ide.eclipse.commons.livexp.util.Parser;

public class ChooseOneSectionCombo<T>
extends AbstractChooseOneSection<T> {
    private final SelectionModel<T> selection;
    private final String label;
    private LiveExpression<T[]> options;
    private Parser<T> inputParser = null;

    public ChooseOneSectionCombo(IPageWithSections owner, String label, SelectionModel<T> selection, T[] options) {
        this(owner, label, selection, LiveExpression.constant(options));
    }

    public ChooseOneSectionCombo(IPageWithSections owner, String label, SelectionModel<T> selection, LiveExpression<T[]> options) {
        super(owner);
        this.label = label;
        this.selection = selection;
        this.options = options;
    }

    public void allowTextEdits(Parser<T> inputParser) {
        this.inputParser = inputParser;
    }

    @Override
    public LiveExpression<ValidationResult> getValidator() {
        return this.selection.validator;
    }

    public LiveVariable<T> getSelection() {
        return this.selection.selection;
    }

    @Override
    public void createContents(Composite page) {
        Composite field = new Composite(page, 0);
        GridLayout layout = GridLayoutFactory.fillDefaults().numColumns(2).create();
        field.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)field);
        Label fieldNameLabel = new Label(field, 0);
        fieldNameLabel.setText(this.label);
        GridDataFactory.fillDefaults().hint(UIConstants.fieldLabelWidthHint((Control)fieldNameLabel), -1).align(1, 0x1000000).applyTo((Control)fieldNameLabel);
        final Combo combo = new Combo(field, this.inputParser == null ? 8 : 0);
        this.options.addListener(new ValueListener<T[]>(){

            @Override
            public void gotValue(LiveExpression<T[]> exp, T[] value) {
                if (combo != null) {
                    String oldText = combo.getText();
                    combo.setItems(ChooseOneSectionCombo.this.getLabels());
                    combo.setText(oldText);
                }
            }
        });
        if (this.inputParser == null) {
            GridDataFactory.fillDefaults().applyTo((Control)combo);
        } else {
            GridDataFactory.fillDefaults().hint(250, -1).applyTo((Control)combo);
        }
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChooseOneSectionCombo.this.handleModifyText(combo);
            }
        });
        this.selection.selection.addListener(new ValueListener<T>(){

            @Override
            public void gotValue(LiveExpression<T> exp, T newSelection) {
                if (newSelection != null) {
                    String newText = ChooseOneSectionCombo.this.labelProvider.getText(newSelection);
                    combo.setText(newText);
                    if (!combo.getText().equals(newText)) {
                        ChooseOneSectionCombo.this.handleModifyText(combo);
                    }
                }
            }
        });
    }

    private void handleModifyText(Combo combo) {
        int selected = combo.getSelectionIndex();
        T[] options = this.getOptionsArray();
        if (options != null && selected >= 0 && selected < options.length) {
            this.selection.selection.setValue(this.getOptionsArray()[selected]);
        } else {
            this.selection.selection.setValue(this.parse(combo.getText()));
        }
    }

    private T parse(String text) {
        try {
            if (this.inputParser != null) {
                return this.inputParser.parse(text);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private String[] getLabels() {
        String[] labels = new String[this.getOptionsArray().length];
        int i = 0;
        while (i < labels.length) {
            labels[i] = this.labelProvider.getText(this.getOptionsArray()[i]);
            ++i;
        }
        return labels;
    }

    private T[] getOptionsArray() {
        return this.options.getValue();
    }

    public LiveExpression<T[]> getOptions() {
        return this.options;
    }

    public LiveVariable<T[]> getOptionsVar() {
        return (LiveVariable)this.options;
    }
}

