/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core.validators;

import java.net.URI;
import java.net.URISyntaxException;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;

public class UrlValidator
extends LiveExpression<ValidationResult> {
    private String fieldName;
    private LiveVariable<String> url;
    private boolean nullable;

    public UrlValidator(String fieldName, LiveVariable<String> url) {
        this(fieldName, url, false);
    }

    public UrlValidator(String fieldName, LiveVariable<String> url, boolean nullable) {
        this.fieldName = fieldName;
        this.url = url;
        this.nullable = nullable;
    }

    @Override
    protected ValidationResult compute() {
        String str = (String)this.url.getValue();
        str = str == null ? "" : str.trim();
        if (this.nullable && str.equals("")) {
            return ValidationResult.OK;
        }
        try {
            new URI(str);
        }
        catch (URISyntaxException e) {
            return ValidationResult.error(String.valueOf(this.fieldName) + " is not a valid URL: URISyntaxException " + e.getMessage());
        }
        return ValidationResult.OK;
    }
}

