/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.launching.JavaRuntime;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class JdtUtils {
    public static final String CLASS_FILE_EXTENSION = ".class";
    public static final String GROOVY_FILE_EXTENSION = ".groovy";
    public static final String JAVA_FILE_EXTENSION = ".java";
    private static final String AJDT_CLASS = "org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager";
    private static final String AJDT_NATURE = "org.eclipse.ajdt.ui.ajnature";
    private static final String CLASSPATH_FILENAME = ".classpath";
    private static final boolean IS_AJDT_PRESENT = JdtUtils.isAjdtPresent();
    private static final String ARRAY_SUFFIX = "[]";

    public static IJavaProject createJavaProject(String projectName, IProgressMonitor monitor) throws CoreException {
        IProject project = SpringCoreUtils.createProject(projectName, null, monitor);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            SpringCoreUtils.addProjectNature(project, "org.eclipse.jdt.core.javanature", monitor);
        }
        IJavaProject jproject = JavaCore.create((IProject)project);
        jproject.setRawClasspath(new IClasspathEntry[]{JdtUtils.getJreVariableEntry()}, monitor);
        jproject.setOutputLocation(project.getFullPath(), monitor);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return jproject;
    }

    public static List<IJavaProject> getAllDependingJavaProjects(IJavaProject project) {
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        if (model != null) {
            try {
                IJavaProject[] projects;
                String[] names = project.getRequiredProjectNames();
                IJavaProject[] iJavaProjectArray = projects = model.getJavaProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject project2 = iJavaProjectArray[n2];
                    String[] stringArray = names;
                    int n3 = names.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String name2 = stringArray[n4];
                        String name = project2.getProject().getName();
                        if (name.equals(name2)) {
                            javaProjects.add(project2);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return javaProjects;
    }

    public static IJavaElement getByHandle(String handle) {
        return JavaCore.create((String)handle);
    }

    public static IJavaProject getJavaProject(IProject project) {
        if (project.isAccessible()) {
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                }
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", "Error getting Java project for project '" + project.getName() + "'", (Throwable)e));
            }
        }
        return null;
    }

    public static IJavaProject getJavaProject(IResource config) {
        IJavaProject project = JavaCore.create((IProject)config.getProject());
        return project;
    }

    public static IType getJavaType(IProject project, String className) {
        IJavaProject javaProject = JdtUtils.getJavaProject(project);
        if (className != null) {
            int pos = className.lastIndexOf(36);
            if (pos > 0) {
                className = className.replace('$', '.');
            }
            try {
                IType type = null;
                if (javaProject != null && (type = javaProject.findType(className, (IProgressMonitor)new NullProgressMonitor())) != null) {
                    return type;
                }
                IProject[] iProjectArray = project.getReferencedProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject refProject = iProjectArray[n2];
                    IJavaProject refJavaProject = JdtUtils.getJavaProject(refProject);
                    if (refJavaProject != null && (type = refJavaProject.findType(className)) != null) {
                        return type;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", "Error getting Java type '" + className + "'", (Throwable)e));
            }
        }
        return null;
    }

    public static final IType getJavaTypeForMethodReturnType(IMethod method, IType contextType) {
        try {
            return JdtUtils.getJavaTypeFromSignatureClassName(method.getReturnType(), contextType);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static IType getJavaTypeFromSignatureClassName(String className, IType contextType) {
        if (contextType == null || className == null) {
            return null;
        }
        try {
            return JdtUtils.getJavaType(contextType.getJavaProject().getProject(), JdtUtils.resolveClassNameBySignature(className, contextType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static final List<IType> getJavaTypesForMethodParameterTypes(IMethod method, IType contextType) {
        String[] parameterTypeNames;
        if (method == null || method.getParameterTypes() == null || method.getParameterTypes().length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IType> parameterTypes = new ArrayList<IType>(method.getParameterTypes().length);
        String[] stringArray = parameterTypeNames = method.getParameterTypes();
        int n = parameterTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterTypeName = stringArray[n2];
            parameterTypes.add(JdtUtils.getJavaTypeFromSignatureClassName(parameterTypeName, contextType));
            ++n2;
        }
        return parameterTypes;
    }

    public static IClasspathEntry getJreVariableEntry() {
        return JavaRuntime.getDefaultJREContainerEntry();
    }

    public static int getLineNumber(IJavaElement element) {
        if (element != null && element instanceof IMethod) {
            try {
                String targetsource;
                IMethod method = (IMethod)element;
                int lines = 0;
                if (method.getDeclaringType() != null && method.getDeclaringType().getCompilationUnit() != null && (targetsource = method.getDeclaringType().getCompilationUnit().getSource()) != null) {
                    String sourceuptomethod = targetsource.substring(0, method.getNameRange().getOffset());
                    char[] chars = new char[sourceuptomethod.length()];
                    sourceuptomethod.getChars(0, sourceuptomethod.length(), chars, 0);
                    char[] cArray = chars;
                    int n = chars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char element0 = cArray[n2];
                        if (element0 == '\n') {
                            ++lines;
                        }
                        ++n2;
                    }
                    return new Integer(lines + 1);
                }
            }
            catch (JavaModelException javaModelException) {}
        } else if (element != null && element instanceof IType && ((IType)element).getCompilationUnit() != null) {
            try {
                IType type = (IType)element;
                int lines = 0;
                String targetsource = type.getCompilationUnit().getSource();
                if (targetsource != null) {
                    String sourceuptomethod = targetsource.substring(0, type.getNameRange().getOffset());
                    char[] chars = new char[sourceuptomethod.length()];
                    sourceuptomethod.getChars(0, sourceuptomethod.length(), chars, 0);
                    char[] cArray = chars;
                    int n = chars.length;
                    int n3 = 0;
                    while (n3 < n) {
                        char element0 = cArray[n3];
                        if (element0 == '\n') {
                            ++lines;
                        }
                        ++n3;
                    }
                    return new Integer(lines + 1);
                }
            }
            catch (JavaModelException javaModelException) {}
        } else if (element != null && element instanceof IField) {
            try {
                String targetsource;
                IField type = (IField)element;
                int lines = 0;
                ICompilationUnit cu = type.getCompilationUnit();
                if (cu != null && (targetsource = cu.getSource()) != null) {
                    String sourceuptomethod = targetsource.substring(0, type.getNameRange().getOffset());
                    char[] chars = new char[sourceuptomethod.length()];
                    sourceuptomethod.getChars(0, sourceuptomethod.length(), chars, 0);
                    char[] cArray = chars;
                    int n = chars.length;
                    int n4 = 0;
                    while (n4 < n) {
                        char element0 = cArray[n4];
                        if (element0 == '\n') {
                            ++lines;
                        }
                        ++n4;
                    }
                    return new Integer(lines + 1);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return new Integer(-1);
    }

    public static String getMethodName(IMethod method) {
        String methodName = method.getElementName();
        int index = methodName.lastIndexOf(46);
        if (index > 0) {
            methodName = methodName.substring(index + 1);
        }
        return methodName;
    }

    public static String[] getParameterTypesString(IMethod method) {
        try {
            String[] parameterQualifiedTypes = Signature.getParameterTypes((String)method.getSignature());
            int length = parameterQualifiedTypes == null ? 0 : parameterQualifiedTypes.length;
            String[] parameterPackages = new String[length];
            int i = 0;
            while (i < length) {
                parameterQualifiedTypes[i] = parameterQualifiedTypes[i].replace('/', '.');
                parameterPackages[i] = Signature.getSignatureSimpleName((String)parameterQualifiedTypes[i]);
                ++i;
            }
            return parameterPackages;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static String getParentName(IMethod method) {
        String methodName = method.getElementName();
        int index = methodName.lastIndexOf(46);
        if (index > 0) {
            return methodName.substring(0, index);
        }
        return method.getParent().getElementName();
    }

    public static String getPropertyNameFromMethodName(IMethod method) {
        String replaceText;
        String methodName = method.getElementName();
        int index = methodName.lastIndexOf(46);
        if (index > 0) {
            methodName = methodName.substring(index + 1);
        }
        if ((replaceText = methodName.substring("set".length())) != null) {
            replaceText = Introspector.decapitalize(replaceText);
        }
        return replaceText;
    }

    public static String getReturnTypeString(IMethod method, boolean classTypesOnly) {
        try {
            String qualifiedReturnType = Signature.getReturnType((String)method.getSignature());
            if (!classTypesOnly || qualifiedReturnType.startsWith("L") || qualifiedReturnType.startsWith("Q")) {
                return Signature.getSignatureSimpleName((String)qualifiedReturnType.replace('/', '.'));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IResource getSourceResource(IResource classFile) {
        try {
            if (JdtUtils.isJavaProject(classFile) && classFile.getName().endsWith(CLASS_FILE_EXTENSION)) {
                int n;
                IPath classFilePath = classFile.getFullPath();
                String classFileName = null;
                IJavaProject project = JdtUtils.getJavaProject(classFile);
                IPath defaultOutput = project.getOutputLocation();
                if (defaultOutput.isPrefixOf(classFilePath)) {
                    classFileName = classFilePath.removeFirstSegments(defaultOutput.segmentCount()).toString();
                } else {
                    IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
                    n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPath output;
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (entry.getEntryKind() == 3 && (output = entry.getOutputLocation()) != null && classFilePath.isPrefixOf(output)) {
                            classFileName = classFilePath.removeFirstSegments(output.segmentCount()).toString();
                        }
                        ++n2;
                    }
                }
                if (classFileName != null) {
                    String sourceFileName = classFileName.replace(CLASS_FILE_EXTENSION, JAVA_FILE_EXTENSION);
                    IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
                    int n3 = iClasspathEntryArray.length;
                    n = 0;
                    while (n < n3) {
                        IClasspathEntry entry = iClasspathEntryArray[n];
                        if (entry.getEntryKind() == 3) {
                            IPath path = entry.getPath().append(sourceFileName).removeFirstSegments(1);
                            IResource resource = project.getProject().findMember(path);
                            if (resource != null) {
                                return resource;
                            }
                        }
                        ++n;
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static boolean isAjdtPresent() {
        try {
            Class.forName(AJDT_CLASS);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isAjdtProject(IResource resource) {
        return SpringCoreUtils.hasNature(resource, AJDT_NATURE);
    }

    public static boolean isClassPathFile(IResource resource) {
        String classPathFileName = resource.getProject().getFullPath().append(CLASSPATH_FILENAME).toString();
        return resource.getFullPath().toString().equals(classPathFileName);
    }

    public static boolean isJavaProject(IResource resource) {
        return SpringCoreUtils.hasNature(resource, "org.eclipse.jdt.core.javanature");
    }

    public static boolean isTypeGroovyElement(IType type) {
        ICompilationUnit cu = type.getCompilationUnit();
        if (cu != null && cu.getResource() != null) {
            return cu.getResource().getName().endsWith(GROOVY_FILE_EXTENSION);
        }
        if (cu != null) {
            try {
                IResource resource = cu.getUnderlyingResource();
                if (resource != null) {
                    return resource.getName().endsWith(GROOVY_FILE_EXTENSION);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return false;
    }

    public static String resolveClassName(String className, IType type) {
        if (className == null || type == null) {
            return className;
        }
        className = className.replace('$', '.');
        String dotClassName = '.' + className;
        IProject project = type.getJavaProject().getProject();
        try {
            String packageName;
            String newClassName;
            if (className.startsWith("java.lang") && JdtUtils.getJavaType(project, className) != null) {
                return className;
            }
            if (!type.isBinary()) {
                int ix = className.lastIndexOf(46);
                String firstClassNameSegment = className;
                if (ix > 0) {
                    firstClassNameSegment = className.substring(0, ix);
                }
                IImportDeclaration[] iImportDeclarationArray = type.getCompilationUnit().getImports();
                int n = iImportDeclarationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String newClassName2;
                    IImportDeclaration importDeclaration = iImportDeclarationArray[n2];
                    String importName = importDeclaration.getElementName();
                    if (importDeclaration.isOnDemand()) {
                        newClassName2 = importName.substring(0, importName.length() - 1) + className;
                        if (JdtUtils.getJavaType(project, newClassName2) != null) {
                            return newClassName2;
                        }
                    } else {
                        if (importName.endsWith(dotClassName) && JdtUtils.getJavaType(project, importName) != null) {
                            return importName;
                        }
                        if (!className.equals(firstClassNameSegment) && importName.endsWith(firstClassNameSegment) && JdtUtils.getJavaType(project, newClassName2 = importName.substring(0, importName.lastIndexOf(46) + 1) + className) != null) {
                            return newClassName2;
                        }
                    }
                    ++n2;
                }
            }
            if (JdtUtils.getJavaType(project, newClassName = (packageName = type.getPackageFragment().getElementName()) + dotClassName) != null) {
                return newClassName;
            }
            if (JdtUtils.getJavaType(project, className) != null) {
                return className;
            }
            newClassName = "java.lang" + dotClassName;
            if (JdtUtils.getJavaType(project, newClassName) != null) {
                return newClassName;
            }
            String[][] fullInter = type.resolveType(className);
            if (fullInter != null && fullInter.length > 0) {
                return String.valueOf(fullInter[0][0]) + "." + fullInter[0][1];
            }
        }
        catch (JavaModelException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", "An error occurred resolving class name", (Throwable)e));
        }
        return className;
    }

    public static String resolveClassNameBySignature(String className, IType type) {
        className = Signature.toString((String)className).replace('$', '.');
        return JdtUtils.resolveClassName(className, type);
    }

    public static void visitTypeAst(IType type, ASTVisitor visitor) {
        if (type != null && type.getCompilationUnit() != null) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(type.getCompilationUnit());
            parser.setResolveBindings(true);
            ASTNode node = parser.createAST((IProgressMonitor)new NullProgressMonitor());
            node.accept(visitor);
        }
    }

    private static String[] getParameterTypesAsStringArray(IMethod method) {
        HashSet<String> typeParameterNames = new HashSet<String>();
        try {
            ITypeParameter param;
            ITypeParameter[] iTypeParameterArray = method.getDeclaringType().getTypeParameters();
            int n = iTypeParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                param = iTypeParameterArray[n2];
                typeParameterNames.add(param.getElementName());
                ++n2;
            }
            iTypeParameterArray = method.getTypeParameters();
            n = iTypeParameterArray.length;
            n2 = 0;
            while (n2 < n) {
                param = iTypeParameterArray[n2];
                typeParameterNames.add(param.getElementName());
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        String[] parameterTypesAsString = new String[method.getParameterTypes().length];
        int i = 0;
        while (i < method.getParameterTypes().length) {
            String parameterTypeString = Signature.getElementType((String)method.getParameterTypes()[i]);
            boolean isArray = !parameterTypeString.equals(method.getParameterTypes()[i]);
            String parameterType = JdtUtils.resolveClassNameBySignature(parameterTypeString, method.getDeclaringType());
            parameterTypesAsString[i] = typeParameterNames.contains(parameterType) ? String.valueOf(Object.class.getName()) + (isArray ? ARRAY_SUFFIX : "") : String.valueOf(parameterType) + (isArray ? ARRAY_SUFFIX : "");
            ++i;
        }
        return parameterTypesAsString;
    }
}

