/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.model.locate;

import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.locate.IBeansConfigLocator;

public abstract class AbstractBeansConfigLocator
implements IBeansConfigLocator {
    protected static final Set<String> FILE_EXTENSIONS = new ConcurrentSkipListSet<String>(Arrays.asList("xml"));

    @Override
    public final boolean isBeansConfig(IFile file) {
        if (file.isAccessible() && this.getAllowedFileExtensions().contains(file.getFileExtension())) {
            Set<IPath> rootPaths = this.getRootDirectories(file.getProject());
            for (IPath path : rootPaths) {
                if (!path.isPrefixOf(file.getFullPath())) continue;
                return this.locateBeansConfigs(file.getProject(), null).contains(file);
            }
        }
        return false;
    }

    protected Set<String> getAllowedFileExtensions() {
        return FILE_EXTENSIONS;
    }

    @Override
    public String getBeansConfigSetName(Set<IFile> files) {
        return null;
    }

    @Override
    public void configureBeansConfigSet(IBeansConfigSet configSet) {
    }

    protected abstract Set<IPath> getRootDirectories(IProject var1);
}

