/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.namespaces;

import java.io.IOException;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.ToolingAwareNamespacePlugins;
import org.springframework.ide.eclipse.beans.core.model.INamespaceDefinitionResolver;
import org.springframework.util.Assert;
import org.xml.sax.EntityResolver;

public class NamespaceManager {
    private ToolingAwareNamespacePlugins namespacePlugins;
    private ServiceRegistration<?> nsResolverRegistration;
    private ServiceRegistration<?> enResolverRegistration = null;
    private ServiceRegistration<?> ndResolverRegistration;
    private final BundleContext context;
    private static final String META_INF = "META-INF/";
    private static final String SPRING_HANDLERS = "spring.handlers";
    private static final String SPRING_SCHEMAS = "spring.schemas";

    public NamespaceManager(BundleContext context) {
        this.context = context;
        this.namespacePlugins = new ToolingAwareNamespacePlugins();
    }

    public void maybeAddNamespaceHandlerFor(Bundle bundle, boolean isLazyBundle) {
        if (this.isSystemBundle(bundle)) {
            return;
        }
        boolean hasHandlers = false;
        boolean hasSchemas = false;
        if (this.context.getBundle().equals(bundle)) {
            try {
                Enumeration handlers = bundle.getResources("META-INF/spring.handlers");
                Enumeration schemas = bundle.getResources("META-INF/spring.schemas");
                hasHandlers = handlers != null;
                hasSchemas = schemas != null;
            }
            catch (IOException iOException) {}
        } else {
            hasHandlers = bundle.findEntries(META_INF, SPRING_HANDLERS, false) != null;
            boolean bl = hasSchemas = bundle.findEntries(META_INF, SPRING_SCHEMAS, false) != null;
        }
        if (hasHandlers) {
            if (isLazyBundle) {
                this.namespacePlugins.addPlugin(bundle, isLazyBundle, true);
            } else if (this.hasCompatibleNamespaceType(bundle)) {
                this.namespacePlugins.addPlugin(bundle, isLazyBundle, false);
            }
        } else if (hasSchemas) {
            this.namespacePlugins.addPlugin(bundle, isLazyBundle, false);
        }
    }

    private boolean isSystemBundle(Bundle bundle) {
        Assert.notNull((Object)bundle);
        return bundle.getBundleId() == 0L;
    }

    private boolean hasCompatibleNamespaceType(Bundle bundle) {
        return this.namespacePlugins.isTypeCompatible(bundle);
    }

    public void maybeRemoveNameSpaceHandlerFor(Bundle bundle) {
        Assert.notNull((Object)bundle);
        this.namespacePlugins.removePlugin(bundle);
    }

    private void registerResolverServices() {
        this.nsResolverRegistration = this.context.registerService(new String[]{NamespaceHandlerResolver.class.getName()}, (Object)this.namespacePlugins, null);
        this.enResolverRegistration = this.context.registerService(new String[]{EntityResolver.class.getName()}, (Object)this.namespacePlugins, null);
        this.ndResolverRegistration = this.context.registerService(new String[]{INamespaceDefinitionResolver.class.getName()}, (Object)this.namespacePlugins, null);
    }

    private void unregisterResolverService() {
        this.unregisterService(this.nsResolverRegistration);
        this.unregisterService(this.enResolverRegistration);
        this.unregisterService(this.ndResolverRegistration);
        this.nsResolverRegistration = null;
        this.enResolverRegistration = null;
        this.ndResolverRegistration = null;
    }

    public boolean unregisterService(ServiceRegistration<?> registration) {
        try {
            if (registration != null) {
                registration.unregister();
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {}
        return false;
    }

    public ToolingAwareNamespacePlugins getNamespacePlugins() {
        return this.namespacePlugins;
    }

    public void afterPropertiesSet() {
        this.registerResolverServices();
    }

    public void destroy() {
        this.unregisterResolverService();
        this.namespacePlugins.destroy();
        this.namespacePlugins = null;
    }
}

