/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import java.util.ArrayList;
import java.util.List;
import ognl.Ognl;
import ognl.OgnlException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ActionComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.PropertiesComposite;
import org.springframework.util.StringUtils;

public class StateTransitionPropertiesDialog
extends TitleAreaDialog
implements IDialogValidator {
    private static final String EXPRESSION_PREFIX = "${";
    private static final String EXPRESSION_SUFFIX = "}";
    private List<IActionElement> actions;
    private Button ognlButton;
    private Button okButton;
    private Text onText;
    private Text onExceptionText;
    private Button browseExceptionButton;
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            StateTransitionPropertiesDialog.this.handleButtonPressed((Button)e.widget);
        }
    };
    private IWebflowModelElement parent;
    private IStateTransition transition;
    private IStateTransition transitionClone;
    private ActionComposite actionProperties;
    private PropertiesComposite properties;
    private boolean displayToBlock = false;
    private Combo toStateText;
    private Label historyLabel;
    private Combo historyText;
    private Button bindText;
    private Label bindLabel;

    public StateTransitionPropertiesDialog(Shell parentShell, IWebflowModelElement parent, IStateTransition state) {
        this(parentShell, parent, state, false);
    }

    public StateTransitionPropertiesDialog(Shell parentShell, IWebflowModelElement parent, IStateTransition state, boolean displayToBlock) {
        super(parentShell);
        this.transition = state;
        this.parent = parent;
        this.transitionClone = (IStateTransition)((ICloneableModelElement)this.transition).cloneModelElement();
        this.actions = new ArrayList<IActionElement>();
        if (this.transitionClone.getActions() != null) {
            this.actions.addAll(this.transitionClone.getActions());
        }
        this.displayToBlock = displayToBlock;
    }

    protected void handleButtonPressed(Button widget) {
        try {
            IType throwable = JdtUtils.getJavaType((IProject)WebflowUtils.getActiveWebflowConfig().getProject().getProject(), (String)"java.lang.Throwable");
            IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])throwable.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor()).getAllSubtypes(throwable));
            FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)new ProgressMonitorDialog(this.getShell()), searchScope, 5);
            dialog.setBlockOnOpen(true);
            dialog.setTitle("Type Selection");
            if (dialog.open() == 0) {
                IType obj = (IType)dialog.getFirstResult();
                this.onExceptionText.setText(obj.getFullyQualifiedName());
            }
        }
        catch (JavaModelException javaModelException) {}
        this.validateInput();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.transitionClone.setOn(this.trimString(this.onText.getText()));
            this.transitionClone.setOnException(this.trimString(this.onExceptionText.getText()));
            if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.transition)) {
                this.transitionClone.setBind(Boolean.toString(this.bindText.getSelection()));
                this.transitionClone.setHistory(this.trimString(this.historyText.getText()));
            }
            if (this.displayToBlock) {
                this.transitionClone.setToStateId(this.trimString(this.toStateText.getText()));
            }
            if (this.actions != null && this.actions.size() > 0) {
                this.transitionClone.removeAll();
                for (IActionElement a : this.actions) {
                    this.transitionClone.addAction(a);
                }
            } else {
                this.transitionClone.removeAll();
            }
            ((ICloneableModelElement)this.transition).applyCloneValues((IWebflowModelElement)this.transitionClone);
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.onText.setFocus();
        if (this.transition != null && (this.transition.getOn() != null || this.transition.getOnException() != null)) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayoutData((Object)new GridData(768));
        TabItem item1 = new TabItem(folder, 0);
        item1.setText("General");
        item1.setImage(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.transition_obj.gif"));
        TabItem item2 = new TabItem(folder, 0);
        TabItem item4 = new TabItem(folder, 0);
        Composite nameGroup = new Composite((Composite)folder, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 2;
        layout1.marginWidth = 0;
        layout1.marginHeight = 0;
        nameGroup.setLayout((Layout)layout1);
        Group groupActionType = new Group(nameGroup, 0);
        groupActionType.setLayoutData((Object)new GridData(1808));
        GridLayout layoutAttMap = new GridLayout();
        layoutAttMap.numColumns = 3;
        layoutAttMap.marginWidth = 5;
        groupActionType.setLayout((Layout)layoutAttMap);
        groupActionType.setText(" Transition ");
        Label onLabel = new Label((Composite)groupActionType, 0);
        onLabel.setText("On");
        this.onText = new Text((Composite)groupActionType, 2052);
        if (this.transition != null && this.transition.getOn() != null) {
            this.onText.setText(this.transition.getOn());
        }
        this.onText.setLayoutData((Object)new GridData(768));
        this.onText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StateTransitionPropertiesDialog.this.validateInput();
            }
        });
        new Label((Composite)groupActionType, 0);
        new Label((Composite)groupActionType, 0);
        this.ognlButton = new Button((Composite)groupActionType, 32);
        this.ognlButton.setText("Parse OGNL transition criteria");
        this.ognlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StateTransitionPropertiesDialog.this.validateInput();
            }
        });
        new Label((Composite)groupActionType, 0);
        Label onExceptionLabel = new Label((Composite)groupActionType, 0);
        onExceptionLabel.setText("On Exception");
        this.onExceptionText = new Text((Composite)groupActionType, 2052);
        if (this.transition != null && this.transition.getOnException() != null) {
            this.onExceptionText.setText(this.transition.getOnException());
        }
        this.onExceptionText.setLayoutData((Object)new GridData(768));
        this.onExceptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StateTransitionPropertiesDialog.this.validateInput();
            }
        });
        this.browseExceptionButton = new Button((Composite)groupActionType, 8);
        this.browseExceptionButton.setText("...");
        this.browseExceptionButton.setLayoutData((Object)new GridData(128));
        this.browseExceptionButton.addSelectionListener(this.buttonListener);
        if (this.displayToBlock) {
            Label toStateLabel = new Label((Composite)groupActionType, 0);
            toStateLabel.setText("To State");
            this.toStateText = new Combo((Composite)groupActionType, 12);
            this.toStateText.setItems(WebflowUtils.getStateId(this.parent));
            if (this.transition != null && this.transition.getToStateId() != null) {
                this.toStateText.setText(this.transition.getToStateId());
            }
            this.toStateText.setLayoutData((Object)new GridData(768));
            this.toStateText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StateTransitionPropertiesDialog.this.validateInput();
                }
            });
            new Label((Composite)groupActionType, 0);
        }
        if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.transition)) {
            this.bindLabel = new Label((Composite)groupActionType, 0);
            this.bindLabel.setText("Bind");
            this.bindText = new Button((Composite)groupActionType, 2080);
            if (this.transition != null && this.transition.getBind() != null && this.transition.getBind().equalsIgnoreCase("true")) {
                this.bindText.setSelection(true);
            }
            this.bindText.setLayoutData((Object)new GridData(768));
            new Label((Composite)groupActionType, 0);
            this.historyLabel = new Label((Composite)groupActionType, 0);
            this.historyLabel.setText("History");
            this.historyText = new Combo((Composite)groupActionType, 2060);
            this.historyText.setItems(new String[]{"", "preserve", "discard", "invalidate"});
            if (this.transition != null && this.transition.getHistory() != null) {
                this.historyText.setText(this.transition.getHistory());
            }
            this.historyText.setLayoutData((Object)new GridData(768));
            new Label((Composite)groupActionType, 0);
        }
        item1.setControl((Control)nameGroup);
        this.actionProperties = new ActionComposite(this, item2, this.getShell(), this.actions, (IWebflowModelElement)this.transitionClone, IActionElement.ACTION_TYPE.ACTION);
        item2.setControl(this.actionProperties.createDialogArea((Composite)folder));
        this.properties = new PropertiesComposite(this, item4, this.getShell(), (IAttributeEnabled)this.transitionClone);
        item4.setControl(this.properties.createDialogArea((Composite)folder));
        StateTransitionPropertiesDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    private String cutExpression(String encodedCriteria) {
        return encodedCriteria.substring(EXPRESSION_PREFIX.length(), encodedCriteria.length() - EXPRESSION_SUFFIX.length());
    }

    public String getMessage() {
        return "Enter the details for the state transition";
    }

    public IWebflowModelElement getModelElementParent() {
        return this.parent;
    }

    protected String getShellTitle() {
        return "Transition";
    }

    protected String getTitle() {
        return "Transition properties";
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.transition_obj.gif");
    }

    protected void handleTableSelectionChanged() {
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    @Override
    public void validateInput() {
        String id = this.onText.getText();
        String onexception = this.onExceptionText.getText();
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (!StringUtils.hasText((String)id) && !StringUtils.hasText((String)onexception)) {
            errorMessage.append("A valid on or on-exception attribute is required. ");
            error = true;
        }
        if (this.ognlButton.getSelection()) {
            if (!id.startsWith(EXPRESSION_PREFIX) || !id.endsWith(EXPRESSION_SUFFIX)) {
                errorMessage.append("A valid OGNL expression needs to start with '${' and ends with '}'. ");
                error = true;
            } else {
                try {
                    Ognl.parseExpression((String)this.cutExpression(id));
                }
                catch (OgnlException ognlException) {
                    errorMessage.append("Malformed OGNL expression. ");
                    error = true;
                }
            }
        }
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }
}

