/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelProvider;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.Action;
import org.springframework.ide.eclipse.webflow.core.internal.model.BeanAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.EvaluateAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.internal.model.InputAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.OutputAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.Set;
import org.springframework.ide.eclipse.webflow.core.model.IActionState;
import org.springframework.ide.eclipse.webflow.core.model.IDecisionState;
import org.springframework.ide.eclipse.webflow.core.model.IEndState;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IInputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IMapping;
import org.springframework.ide.eclipse.webflow.core.model.IOutputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.ISubflowState;
import org.springframework.ide.eclipse.webflow.core.model.IViewState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.Activator;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ActionPropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ActionStatePropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.BeanActionPropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DecisionStatePropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.EndStatePropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.EvaluateActionPropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ExceptionHandlerPropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IfPropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.InputAttributeEditorDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.MappingEditorDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.SetActionPropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.StateTransitionPropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.SubFlowStatePropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ViewStatePropertiesDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.WebflowStatePropertiesDialog;

public class DialogUtils {
    public static int openPropertiesDialog(IWebflowModelElement parent, IWebflowModelElement element, boolean newMode) {
        return DialogUtils.openPropertiesDialog(parent, element, newMode, 0);
    }

    public static int openPropertiesDialog(final IWebflowModelElement parent, final IWebflowModelElement element, final boolean newMode, final int index) {
        final Integer[] result = new Integer[1];
        final Shell shell = DialogUtils.getShell();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TitleAreaDialog dialog = null;
                if (element instanceof IEndState) {
                    dialog = new EndStatePropertiesDialog(shell, parent, (IEndState)element);
                } else if (element instanceof IViewState) {
                    dialog = new ViewStatePropertiesDialog(shell, parent, (IViewState)element);
                } else if (element instanceof ISubflowState) {
                    dialog = new SubFlowStatePropertiesDialog(shell, parent, (ISubflowState)element, index);
                } else if (element instanceof IActionState) {
                    dialog = new ActionStatePropertiesDialog(shell, parent, (IActionState)element);
                } else if (element instanceof Action) {
                    dialog = new ActionPropertiesDialog(shell, parent, (Action)element);
                } else if (element instanceof BeanAction) {
                    dialog = new BeanActionPropertiesDialog(shell, parent, (BeanAction)element);
                } else if (element instanceof EvaluateAction) {
                    dialog = new EvaluateActionPropertiesDialog(shell, parent, (EvaluateAction)element);
                } else if (element instanceof Set) {
                    dialog = new SetActionPropertiesDialog(shell, parent, (Set)element);
                } else if (element instanceof OutputAttribute) {
                    dialog = new InputAttributeEditorDialog(shell, (IInputAttribute)((IOutputAttribute)element));
                } else if (element instanceof InputAttribute) {
                    dialog = new InputAttributeEditorDialog(shell, (IInputAttribute)element);
                } else if (element instanceof IMapping) {
                    dialog = new MappingEditorDialog(shell, (IMapping)element);
                } else if (element instanceof ExceptionHandler) {
                    dialog = new ExceptionHandlerPropertiesDialog(shell, parent, (ExceptionHandler)element);
                } else if (element instanceof IStateTransition) {
                    dialog = new StateTransitionPropertiesDialog(shell, parent, (IStateTransition)element);
                } else if (element instanceof IDecisionState) {
                    dialog = new DecisionStatePropertiesDialog(shell, parent, (IDecisionState)element);
                } else if (element instanceof IIf) {
                    dialog = new IfPropertiesDialog(shell, (IDecisionState)parent, (IIf)element, newMode);
                } else if (element instanceof IWebflowState) {
                    dialog = new WebflowStatePropertiesDialog(shell, (IWebflowState)element);
                }
                if (dialog != null) {
                    dialog.setBlockOnOpen(true);
                    result[0] = dialog.open();
                }
            }
        });
        return result[0];
    }

    private static Shell getShell() {
        Shell shell = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        return shell;
    }

    public static ElementListSelectionDialog openBeanReferenceDialog(String beanId, boolean filter) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(DialogUtils.getShell(), (ILabelProvider)new BeansModelLabelProvider(true));
        dialog.setBlockOnOpen(true);
        dialog.setSize(100, 20);
        if (filter) {
            dialog.setFilter("*" + beanId + "*");
        }
        dialog.setElements(WebflowUtils.getBeansFromEditorInput().toArray());
        dialog.setEmptySelectionMessage("Select a bean reference");
        dialog.setTitle("Bean reference");
        dialog.setMessage("Please select a bean reference");
        dialog.setMultipleSelection(false);
        return dialog;
    }

    public static ElementListSelectionDialog openActionMethodReferenceDialog(IDOMNode node) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(DialogUtils.getShell(), (ILabelProvider)new JavaElementLabelProvider());
        dialog.setBlockOnOpen(true);
        dialog.setSize(100, 20);
        dialog.setElements(WebflowUtils.getActionMethods(node).toArray());
        dialog.setEmptySelectionMessage("Select a action method");
        dialog.setTitle("Action method reference");
        dialog.setMessage("Please select a action method");
        dialog.setMultipleSelection(false);
        return dialog;
    }

    public static ElementListSelectionDialog openFlowReferenceDialog() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(DialogUtils.getShell(), (ILabelProvider)new LabelProvider(){

            public Image getImage(Object obj) {
                return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.spring_webflow_obj.gif");
            }
        });
        dialog.setBlockOnOpen(true);
        dialog.setSize(100, 20);
        dialog.setElements((Object[])WebflowUtils.getWebflowConfigNames());
        dialog.setEmptySelectionMessage("Select a flow reference");
        dialog.setTitle("Flow reference");
        dialog.setMessage("Please select a flow");
        dialog.setMultipleSelection(false);
        return dialog;
    }

    public static void attachContentAssist(Text text, Object[] elements) {
        try {
            char[] autoActivationCharacters = new char[]{};
            KeyStroke keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
            new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(elements), keyStroke, autoActivationCharacters);
        }
        catch (ParseException parseException) {}
    }

    private static class SimpleContentProposalProvider
    implements IContentProposalProvider {
        private String[] proposals;

        public SimpleContentProposalProvider(String[] proposals) {
            Arrays.sort(proposals);
            this.proposals = proposals;
        }

        public SimpleContentProposalProvider(Object[] proposals) {
            if (proposals != null && proposals.length > 0) {
                ArrayList<String> strings = new ArrayList<String>();
                Object[] objectArray = proposals;
                int n = proposals.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof IModelElement) {
                        strings.add(((IModelElement)obj).getElementName());
                    } else if (obj instanceof IMethod) {
                        strings.add(((IMethod)obj).getElementName());
                    }
                    ++n2;
                }
                this.proposals = strings.toArray(new String[strings.size()]);
                Arrays.sort(this.proposals);
            } else {
                this.proposals = new String[0];
            }
        }

        public IContentProposal[] getProposals(String contents, final int position) {
            ArrayList<1> contentProposals = new ArrayList<1>();
            int i = 0;
            while (i < this.proposals.length) {
                final String proposal = this.proposals[i];
                if (proposal.startsWith(contents)) {
                    contentProposals.add(new IContentProposal(){

                        public String getContent() {
                            return proposal.substring(position);
                        }

                        public String getDescription() {
                            return null;
                        }

                        public String getLabel() {
                            return proposal;
                        }

                        public int getCursorPosition() {
                            return proposal.length();
                        }
                    });
                }
                ++i;
            }
            return contentProposals.toArray(new IContentProposal[contentProposals.size()]);
        }

        public void setProposals(String[] items) {
            this.proposals = items;
        }
    }
}

