/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IActionState;
import org.springframework.ide.eclipse.webflow.core.model.IEntryActions;
import org.springframework.ide.eclipse.webflow.core.model.IExitActions;
import org.springframework.ide.eclipse.webflow.core.model.IRenderActions;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;

public class DeleteActionCommand
extends Command {
    private IActionElement child;
    private int index = -1;

    public void execute() {
        this.primExecute();
    }

    protected void primExecute() {
        IWebflowModelElement parent = (IWebflowModelElement)this.child.getElementParent();
        if (parent instanceof IEntryActions) {
            this.index = ((IEntryActions)parent).getEntryActions().indexOf(this.child);
            ((IEntryActions)parent).removeEntryAction(this.child);
        } else if (parent instanceof IExitActions) {
            this.index = ((IExitActions)parent).getExitActions().indexOf(this.child);
            ((IExitActions)parent).removeExitAction(this.child);
        } else if (parent instanceof IRenderActions) {
            this.index = ((IRenderActions)parent).getRenderActions().indexOf(this.child);
            ((IRenderActions)parent).removeRenderAction(this.child);
        } else if (parent instanceof IActionState) {
            this.index = ((IActionState)parent).getActions().indexOf(this.child);
            ((IActionState)parent).removeAction(this.child);
        }
    }

    public void redo() {
        this.primExecute();
    }

    public void setChild(IActionElement a) {
        this.child = a;
    }

    public void undo() {
        IWebflowModelElement parent = (IWebflowModelElement)this.child.getElementParent();
        if (parent instanceof IEntryActions) {
            ((IEntryActions)parent).addEntryAction(this.child, this.index);
        } else if (parent instanceof IExitActions) {
            ((IExitActions)parent).addExitAction(this.child, this.index);
        } else if (parent instanceof IRenderActions) {
            ((IRenderActions)parent).addRenderAction(this.child, this.index);
        } else if (parent instanceof IActionState) {
            ((IActionState)parent).addAction(this.child, this.index);
        }
    }
}

