/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.util;

import com.atlassian.theplugin.commons.exception.IncorrectVersionException;
import java.io.Serializable;
import java.util.Scanner;
import java.util.regex.MatchResult;

public class ProductVersionUtil
implements Serializable {
    public static final String SPECIAL_DEV_VERSION = "${project.version}, SVN:${buildNumber}";
    public static final ProductVersionUtil NULL_VERSION = ProductVersionUtil.initNullVersion();
    private static final long serialVersionUID = 1846608052207718100L;
    private transient VersionNumber versionNumber;
    private final String version;
    private static final String PATTERN = "^(\\d+)\\.(\\d+)(\\.(\\d+))?(\\.(\\d+))?(.+)?$";
    private static final int MAJOR_TOKEN_GRP = 1;
    private static final int MINOR_TOKEN_GRP = 2;
    private static final int MICRO_TOKEN_GRP = 4;
    private static final int NANO_TOKEN_GRP = 6;

    private static ProductVersionUtil initNullVersion() {
        ProductVersionUtil result = null;
        try {
            result = new ProductVersionUtil("0.0.0.0");
        }
        catch (IncorrectVersionException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ProductVersionUtil(String version) throws IncorrectVersionException {
        this.version = version;
        this.parseVersionString(version);
    }

    public ProductVersionUtil() throws IncorrectVersionException {
        this(NULL_VERSION.getVersion());
    }

    public String getVersion() {
        return this.version;
    }

    private void parseVersionString(String aVersion) throws IncorrectVersionException {
        if (!aVersion.equals(SPECIAL_DEV_VERSION)) {
            this.tokenize(aVersion.toUpperCase());
        }
    }

    private void tokenize(String aVersion) throws IncorrectVersionException {
        Scanner s = new Scanner(aVersion);
        s.findInLine(PATTERN);
        try {
            MatchResult result = s.match();
            this.versionNumber = new VersionNumber(Integer.valueOf(result.group(1)), Integer.valueOf(result.group(2)), result.group(4) != null ? Integer.valueOf(result.group(4)) : -1, result.group(6) != null ? Integer.valueOf(result.group(6)) : -1);
        }
        catch (IllegalStateException ex) {
            throw new IncorrectVersionException("Version (" + aVersion + ") does not match pattern (\"" + PATTERN + "\")", ex);
        }
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ProductVersionUtil thatVersion = (ProductVersionUtil)that;
        return !(this.version != null ? !this.version.equals(thatVersion.version) : thatVersion.version != null);
    }

    public int hashCode() {
        return this.version != null ? this.version.hashCode() : 0;
    }

    public String toString() {
        return this.version;
    }

    public boolean greater(ProductVersionUtil other) {
        if (other == null) {
            return false;
        }
        if (other.version.equals(SPECIAL_DEV_VERSION)) {
            return false;
        }
        if (this.version.equals(SPECIAL_DEV_VERSION)) {
            return true;
        }
        return this.getVersionNumber().greater(other.getVersionNumber());
    }

    private VersionNumber getVersionNumber() {
        return this.versionNumber;
    }

    private static class VersionNumber {
        private final int major;
        private final int minor;
        private final int micro;
        private final int nano;
        private static final int PRIME = 31;

        public VersionNumber(int major, int minor, int micro, int nano) throws IncorrectVersionException {
            this.major = major;
            this.minor = minor;
            this.micro = micro;
            this.nano = nano;
        }

        public boolean greater(VersionNumber other) {
            if (other == null) {
                return false;
            }
            if (this.major > other.major) {
                return true;
            }
            if (this.major == other.major && this.minor > other.minor) {
                return true;
            }
            if (this.major == other.major && this.minor == other.minor && this.micro > other.micro) {
                return true;
            }
            return this.major == other.major && this.minor == other.minor && this.micro == other.micro && this.nano > other.nano;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionNumber that = (VersionNumber)o;
            if (this.major != that.major) {
                return false;
            }
            if (this.micro != that.micro) {
                return false;
            }
            if (this.minor != that.minor) {
                return false;
            }
            return this.nano == that.nano;
        }

        public int hashCode() {
            int result = this.major;
            result = 31 * result + this.minor;
            result = 31 * result + this.micro;
            result = 31 * result + this.nano;
            return result;
        }
    }
}

